/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.HorizontalCommand;
import jade.core.Node;
import jade.imtp.leap.Command;
import jade.imtp.leap.Skeleton;

class NodeSkel
extends Skeleton {
    private Node myNode;

    public NodeSkel(Node n) {
        this.myNode = n;
    }

    public Command executeCommand(Command command) throws Throwable {
        switch (command.getCode()) {
            case 8: {
                HorizontalCommand cmd = (HorizontalCommand)command.getParamAt(0);
                Object result = this.myNode.accept(cmd);
                command.reset(1);
                command.addParam(result);
                break;
            }
            case 9: 
            case 10: {
                Boolean hang = (Boolean)command.getParamAt(0);
                Boolean result = new Boolean(this.myNode.ping(hang));
                command.reset(1);
                command.addParam(result);
                break;
            }
            case 11: {
                this.myNode.exit();
                command.reset(1);
                break;
            }
            case 12: {
                this.myNode.interrupt();
                command.reset(1);
                break;
            }
            case 16: {
                String deadPMAddress = (String)command.getParamAt(0);
                String notifyingPMAddress = (String)command.getParamAt(1);
                this.myNode.platformManagerDead(deadPMAddress, notifyingPMAddress);
                command.reset(1);
                break;
            }
        }
        return command;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.myNode.getName() + "]";
    }
}

