/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.core.BackEnd;
import jade.core.FEConnectionManager;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Specifier;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndStub;
import jade.imtp.leap.ConnectionListener;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndSkel;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.MicroSkeleton;
import jade.imtp.leap.http.HTTPClientConnection;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Vector;

public class HTTPFEDispatcher
implements FEConnectionManager,
Dispatcher,
TimerListener {
    private MicroSkeleton mySkel;
    private BackEndStub myStub;
    private Thread terminator;
    private DisconnectionManager myDisconnectionManager;
    private KeepAliveManager myKeepAliveManager;
    private InputManager myInputManager;
    private int outCnt;
    private boolean waitingForFlush = false;
    private long maxDisconnectionTime;
    private long keepAliveTime;
    private Properties props;
    private TransportAddress mediatorTA;
    private String myMediatorID;
    private String owner;
    private String beAddrsText;
    private String[] backEndAddresses;
    private ConnectionListener myConnectionListener;
    private Object connectorLock = new Object();
    private boolean locked = false;
    private int verbosity = 1;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    protected String myMediatorClass = "jade.imtp.leap.http.HTTPBEDispatcher";
    private JICPPacket lastResponse = null;
    private byte lastSid = (byte)16;
    private int cnt = 0;

    public BackEnd getBackEnd(FrontEnd fe, Properties p) throws IMTPException {
        this.props = p;
        this.beAddrsText = this.props.getProperty("beaddrs");
        this.backEndAddresses = this.parseBackEndAddresses(this.beAddrsText);
        String host = this.props.getProperty("host");
        if (host == null) {
            host = "localhost";
        }
        int port = 1099;
        try {
            port = Integer.parseInt(this.props.getProperty("port"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        this.mediatorTA = JICPProtocol.getInstance().buildAddress(host, String.valueOf(port), null, null);
        String tmp = this.props.getProperty("mediator-class");
        if (tmp != null) {
            this.myMediatorClass = tmp;
        } else {
            this.props.setProperty("mediator-class", this.myMediatorClass);
        }
        long retryTime = 10000L;
        try {
            retryTime = Long.parseLong(this.props.getProperty("reconnection-retry-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(this.props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            this.props.setProperty("max-disconnection-time", String.valueOf(this.maxDisconnectionTime));
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(this.props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            this.props.setProperty("keep-alive-time", String.valueOf(this.keepAliveTime));
        }
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Remote URL = http://" + host + ":" + port);
            this.myLogger.log(Logger.CONFIG, "Mediator class = " + this.myMediatorClass);
            this.myLogger.log(Logger.CONFIG, "Reconnection retry time = " + retryTime);
            this.myLogger.log(Logger.CONFIG, "Max disconnection time = " + this.maxDisconnectionTime);
            this.myLogger.log(Logger.CONFIG, "Keep-alive time = " + this.keepAliveTime);
        }
        this.myDisconnectionManager = new DisconnectionManager(retryTime, this.maxDisconnectionTime);
        this.myKeepAliveManager = new KeepAliveManager(this.keepAliveTime);
        this.myInputManager = new InputManager();
        this.owner = this.props.getProperty("owner");
        this.myStub = new BackEndStub(this);
        this.mySkel = new FrontEndSkel(fe);
        this.myInputManager.start();
        this.createBackEnd();
        return this.myStub;
    }

    public void shutdown() {
        this.terminator = Thread.currentThread();
        this.myLogger.log(Logger.INFO, "Dispatcher shutting down. Self-initiated = " + (this.terminator != this.myInputManager));
        if (this.terminator != this.myInputManager) {
            if (this.myDisconnectionManager.isReachable()) {
                JICPPacket pkt = new JICPPacket(0, 0, null);
                this.myLogger.log(Logger.INFO, "Pushing termination notification");
                try {
                    this.deliver(pkt);
                }
                catch (IOException ioe) {
                    this.myLogger.log(Logger.FINE, "BackEnd closed");
                }
            }
            this.myInputManager.kill();
        }
    }

    private synchronized void createBackEnd() throws IMTPException {
        StringBuffer sb = BackEndStub.encodeCreateMediatorRequest(this.props);
        if (this.myMediatorID != null) {
            BackEndStub.appendProp(sb, "mediator-id", this.myMediatorID);
            BackEndStub.appendProp(sb, "outcnt", String.valueOf(this.outCnt));
            BackEndStub.appendProp(sb, "lastsid", String.valueOf(this.lastSid));
        }
        JICPPacket pkt = new JICPPacket(22, 0, null, sb.toString().getBytes());
        for (int i = -1; i < this.backEndAddresses.length; ++i) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                HTTPClientConnection hc = (HTTPClientConnection)this.getConnection(this.mediatorTA);
                this.myLogger.log(Logger.INFO, "Creating BackEnd on " + hc.getProtocol() + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort());
                pkt = this.deliver(pkt);
                String replyMsg = new String(pkt.getData());
                if (pkt.getType() != 100) {
                    BackEndStub.parseCreateMediatorResponse(replyMsg, this.props);
                    this.myMediatorID = this.props.getProperty("mediator-id");
                    this.mediatorTA = new JICPAddress(this.mediatorTA.getHost(), this.mediatorTA.getPort(), this.myMediatorID, null);
                    this.myDisconnectionManager.setReachable();
                    this.myKeepAliveManager.update();
                    this.myLogger.log(Logger.INFO, "BackEnd OK. Mediator ID is " + this.myMediatorID);
                    return;
                }
                this.myLogger.log(Logger.WARNING, "Mediator error: " + replyMsg);
                continue;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connection error", ioe);
            }
        }
        throw new IMTPException("Error creating the BackEnd.");
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.myDisconnectionManager.isReachable()) {
            if (this.waitingForFlush && !flush) {
                throw new ICPException("Upsetting dispatching order");
            }
            this.waitingForFlush = false;
            int sid = this.outCnt;
            this.outCnt = this.outCnt + 1 & 0xF;
            this.myLogger.log(Logger.FINE, "Issuing outgoing command " + sid);
            try {
                JICPPacket pkt = new JICPPacket(0, 0, payload);
                pkt.setSessionID((byte)sid);
                pkt = this.deliver(pkt);
                this.myLogger.log(Logger.FINE, "Response received " + pkt.getSessionID());
                if (pkt.getType() == 100) {
                    throw new ICPException(new String(pkt.getData()));
                }
                return pkt.getData();
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "IOException on output connection", ioe);
                this.myDisconnectionManager.setUnreachable(false);
                throw new ICPException("Dispatching error.", ioe);
            }
        }
        throw new ICPException("Unreachable");
    }

    protected Connection getConnection(TransportAddress ta) {
        return new HTTPClientConnection(ta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JICPPacket deliver(JICPPacket pkt) throws IOException {
        JICPPacket jICPPacket;
        Connection c = this.getConnection(this.mediatorTA);
        try {
            jICPPacket = this.deliver(pkt, c);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                c.close();
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return jICPPacket;
    }

    private JICPPacket deliver(JICPPacket pkt, Connection c) throws IOException {
        boolean lastPacket = false;
        if (Thread.currentThread() == this.terminator) {
            pkt.setTerminatedInfo(true);
            lastPacket = true;
        }
        pkt.setRecipientID(this.mediatorTA.getFile());
        byte type = pkt.getType();
        int status = 0;
        try {
            c.writePacket(pkt);
            status = 1;
            pkt = c.readPacket();
            status = 2;
            if (lastPacket && (pkt.getInfo() & 0x40) != 0) {
                this.myLogger.log(Logger.INFO, "Termination notification ACK received");
                throw new IOException("Terminated-info");
            }
            JICPPacket jICPPacket = pkt;
            Object var8_8 = null;
            return jICPPacket;
        }
        catch (IOException ioe) {
            try {
                throw new IOException(ioe.getMessage() + '[' + status + ']');
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    public void doTimeOut(Timer t) {
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        Object object = this.connectorLock;
        synchronized (object) {
            while (this.locked) {
                try {
                    this.connectorLock.wait();
                }
                catch (Exception exception) {}
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.connectorLock;
        synchronized (object) {
            this.locked = false;
            this.connectorLock.notifyAll();
        }
    }

    private boolean ping(int cnt) throws ICPException {
        for (int i = -1; i < this.backEndAddresses.length; ++i) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                this.myLogger.log(Logger.FINE, "Ping " + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort() + "(" + cnt + ")...");
                JICPPacket pkt = new JICPPacket(23, 0, null);
                pkt = this.deliver(pkt);
                if (pkt.getType() == 100) {
                    String errorMsg = new String(pkt.getData());
                    if (errorMsg.equals("Not-found")) {
                        this.myLogger.log(Logger.WARNING, "Communication OK, but Back-end no longer present. Try to recreate it");
                        if (this.myConnectionListener != null) {
                            this.myConnectionListener.handleConnectionEvent(6, null);
                        }
                        try {
                            this.createBackEnd();
                        }
                        catch (IMTPException imtpe) {
                            this.myLogger.log(Logger.WARNING, "Error re-creating the Back-end.");
                            return false;
                        }
                    } else {
                        throw new ICPException("JICP error. " + errorMsg);
                    }
                }
                return true;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.FINE, "Ping KO", ioe);
                continue;
            }
        }
        return false;
    }

    private String[] parseBackEndAddresses(String addressesText) {
        Vector addrs = Specifier.parseList(addressesText, ';');
        String[] result = new String[addrs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)addrs.elementAt(i);
        }
        return result;
    }

    private class KeepAliveManager
    implements TimerListener {
        private long kaTimeout = -1L;
        private Timer kaTimer;

        private KeepAliveManager(long keepAliveTime) {
            if (keepAliveTime > 0L) {
                this.kaTimeout = keepAliveTime * 2L;
            }
        }

        public synchronized void doTimeOut(Timer t) {
            if (t == this.kaTimer) {
                HTTPFEDispatcher.this.myLogger.log(Logger.WARNING, "Missing Keep-alive");
                HTTPFEDispatcher.this.myDisconnectionManager.setUnreachable(true);
            }
        }

        private synchronized void update() {
            if (this.kaTimeout > 0L) {
                TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
                if (this.kaTimer != null) {
                    td.remove(this.kaTimer);
                }
                this.kaTimer = td.add(new Timer(System.currentTimeMillis() + this.kaTimeout, this));
            }
        }
    }

    class DisconnectionManager
    implements Runnable {
        private boolean reachable = false;
        private boolean pingOK = false;
        private Thread myThread;
        private long retryTime;
        private long maxDisconnectionTime;

        private DisconnectionManager(long retryTime, long maxDisconnectionTime) {
            this.retryTime = retryTime;
            this.maxDisconnectionTime = maxDisconnectionTime;
        }

        private final synchronized boolean isReachable() {
            return this.reachable;
        }

        private synchronized void setUnreachable(boolean missingKA) {
            if (this.reachable && (missingKA || !this.pingOK)) {
                if (HTTPFEDispatcher.this.myConnectionListener != null) {
                    HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(2, null);
                }
                this.reachable = false;
                HTTPFEDispatcher.this.myLogger.log(Logger.INFO, "Starting DM (" + System.currentTimeMillis() + ").");
                this.myThread = new Thread(this);
                this.myThread.start();
                if (this.pingOK) {
                    HTTPFEDispatcher.this.myInputManager.kill();
                    HTTPFEDispatcher.this.myInputManager = new InputManager();
                    HTTPFEDispatcher.this.myInputManager.start();
                }
            }
        }

        private synchronized void setReachable() {
            this.reachable = true;
            if (HTTPFEDispatcher.this.myConnectionListener != null) {
                HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(3, null);
            }
            this.notifyAll();
        }

        synchronized void waitUntilReachable() {
            while (!this.reachable) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.pingOK = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                int attemptCnt = 0;
                long startTime = System.currentTimeMillis();
                try {
                    while (!HTTPFEDispatcher.this.ping(attemptCnt)) {
                        ++attemptCnt;
                        if (System.currentTimeMillis() - startTime > this.maxDisconnectionTime) {
                            throw new ICPException("Max disconnection timeout expired");
                        }
                        this.waitABit(this.retryTime);
                    }
                    HTTPFEDispatcher.this.myLogger.log(Logger.INFO, "Reconnection ping OK.");
                    DisconnectionManager disconnectionManager = this;
                    synchronized (disconnectionManager) {
                        this.pingOK = true;
                        this.setReachable();
                        HTTPFEDispatcher.this.myKeepAliveManager.update();
                        HTTPFEDispatcher.this.waitingForFlush = HTTPFEDispatcher.this.myStub.flush();
                    }
                }
                catch (ICPException icpe) {
                    HTTPFEDispatcher.this.myLogger.log(Logger.SEVERE, "Impossible to reconnect to the BackEnd (" + System.currentTimeMillis() + ")", icpe);
                    if (HTTPFEDispatcher.this.myConnectionListener == null) break block7;
                    HTTPFEDispatcher.this.myConnectionListener.handleConnectionEvent(5, null);
                }
            }
        }

        private void waitABit(long time) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class InputManager
    extends Thread {
        private boolean active = true;
        private Connection myConnection = null;
        private int myId;

        private InputManager() {
        }

        public void run() {
            if (HTTPFEDispatcher.this.cnt == 0) {
                Thread.yield();
                try {
                    HTTPFEDispatcher.this.myConnectionListener = (ConnectionListener)Class.forName(HTTPFEDispatcher.this.props.getProperty("connection-listener")).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.myId = HTTPFEDispatcher.this.cnt++;
            HTTPFEDispatcher.this.myLogger.log(Logger.INFO, "IM-" + this.myId + " started");
            JICPPacket rsp = new JICPPacket(1, 0, null);
            while (this.active) {
                try {
                    this.refreshConnection();
                    HTTPFEDispatcher.this.myDisconnectionManager.waitUntilReachable();
                    if (this == HTTPFEDispatcher.this.terminator) {
                        this.active = false;
                    }
                    JICPPacket cmd = HTTPFEDispatcher.this.deliver(rsp, this.myConnection);
                    HTTPFEDispatcher.this.myKeepAliveManager.update();
                    if (cmd.getType() == 2) {
                        if (HTTPFEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                            HTTPFEDispatcher.this.myLogger.log(Logger.FINER, "Keep-alive received");
                        }
                        rsp = new JICPPacket(1, 32, null);
                        continue;
                    }
                    byte sid = cmd.getSessionID();
                    if (sid == HTTPFEDispatcher.this.lastSid) {
                        HTTPFEDispatcher.this.myLogger.log(Logger.WARNING, "Duplicated command received " + sid);
                        rsp = HTTPFEDispatcher.this.lastResponse;
                        continue;
                    }
                    HTTPFEDispatcher.this.myLogger.log(Logger.FINE, "Incoming command received " + sid);
                    byte[] rspData = HTTPFEDispatcher.this.mySkel.handleCommand(cmd.getData());
                    HTTPFEDispatcher.this.myLogger.log(Logger.FINE, "Incoming command served " + sid);
                    rsp = new JICPPacket(1, 0, rspData);
                    rsp.setSessionID(sid);
                    HTTPFEDispatcher.this.lastSid = sid;
                    HTTPFEDispatcher.this.lastResponse = rsp;
                }
                catch (Exception e) {
                    if (!this.active) continue;
                    HTTPFEDispatcher.this.myLogger.log(Logger.WARNING, "Exception on input connection", e);
                    HTTPFEDispatcher.this.myDisconnectionManager.setUnreachable(false);
                }
            }
            HTTPFEDispatcher.this.myLogger.log(Logger.INFO, "IM-" + this.myId + " terminated");
        }

        private synchronized void refreshConnection() throws IOException {
            if (this.active) {
                if (this.myConnection != null) {
                    this.myConnection.close();
                }
            } else {
                throw new IOException("Killed");
            }
            this.myConnection = HTTPFEDispatcher.this.getConnection(HTTPFEDispatcher.this.mediatorTA);
        }

        private synchronized void kill() {
            this.active = false;
            try {
                this.myConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myConnection = null;
        }
    }
}

