/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.dfgui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.gui.DFAgentDscDlg;
import jade.gui.GuiEvent;
import jade.tools.dfgui.DFGUI;
import jade.util.Logger;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class DFGUIModifyAction
extends AbstractAction {
    private DFGUI gui;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public DFGUIModifyAction(DFGUI gui) {
        super("Modify");
        this.gui = gui;
    }

    public void actionPerformed(ActionEvent e) {
        int kind = this.gui.kindOfOperation();
        AID name = this.gui.getSelectedAgentInTable();
        DFAgentDescription dfd = null;
        AID df2 = this.gui.myAgent.getDescriptionOfThisDF().getName();
        if (name != null) {
            if (kind == DFGUI.AGENT_VIEW) {
                try {
                    dfd = this.gui.myAgent.getDFAgentDsc(name);
                }
                catch (FIPAException fe) {
                    if (this.logger.isLoggable(Logger.WARNING)) {
                        this.logger.log(Logger.WARNING, "No agent called " + name + " is currently registered with this DF");
                    }
                    return;
                }
            } else if (kind == DFGUI.LASTSEARCH_VIEW) {
                dfd = this.gui.getDFAgentSearchDsc(name);
                df2 = this.gui.getLastDF();
            }
            DFAgentDscDlg dlg = new DFAgentDscDlg(this.gui);
            DFAgentDescription editedDfd = dlg.ShowDFDGui(dfd, true, true);
            if (editedDfd != null) {
                GuiEvent ev = new GuiEvent(this.gui, 1003);
                ev.addParameter(df2);
                ev.addParameter(editedDfd);
                this.gui.myAgent.postGuiEvent(ev);
            }
        }
    }
}

