/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.lang.acl.ACLMessage;
import jade.util.leap.Properties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ACLPropertyList
extends JPanel {
    private boolean editable = true;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JList contentList = new JList();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private DefaultListModel listModel = new DefaultListModel();
    private ACLPropertyListCellRenderer aclPropertyListCellRenderer = new ACLPropertyListCellRenderer();
    private ACLPropertyListener theDataListener = new ACLPropertyListener();
    private JScrollPane contentScrollPane = new JScrollPane();
    private String fieldName = "";
    private ACLMessage msg;

    public ACLPropertyList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEditable(boolean theBool) {
        if (!theBool) {
            this.editable = false;
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void register(ACLMessage msg, String fieldName) {
        this.listModel = new DefaultListModel();
        this.msg = msg;
        this.fieldName = fieldName;
        Properties prop = msg.getAllUserDefinedParameters();
        this.aclPropertyListCellRenderer.register(msg);
        Enumeration<Object> enumeration = prop.elements();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.listModel.addElement(key);
        }
        this.contentList.setModel(this.listModel);
        this.theDataListener.register(msg, fieldName);
        this.listModel.addListDataListener(this.theDataListener);
    }

    void doView() {
        String currentKey;
        int index = this.contentList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String editKey = currentKey = (String)this.listModel.getElementAt(index);
        ACLPropertyDialog theDialog = new ACLPropertyDialog();
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setItskey(editKey);
        theDialog.setItsvalue(this.msg.getAllUserDefinedParameters().getProperty(editKey));
        theDialog.setEdit();
        theDialog.setEditable(this.editable);
        theDialog.setTitle(this.editable ? "Edit property: " + currentKey : "View property: " + currentKey);
        theDialog.setVisible(true);
        if (theDialog.getOK()) {
            this.theDataListener.registerChangedProperty(currentKey, theDialog.getItsvalue());
            this.listModel.setElementAt(currentKey, index);
        }
    }

    void deleteButton_actionPerformed(ActionEvent e) {
        this.doDelete();
    }

    void doDelete() {
        int index = this.contentList.getSelectedIndex();
        if (index >= 0) {
            this.theDataListener.registerRemovedKey((String)this.listModel.getElementAt(index));
            this.listModel.remove(index);
        }
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.doAdd();
    }

    void doAdd() {
        ACLPropertyDialog theDialog = new ACLPropertyDialog();
        theDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        theDialog.setVisible(true);
        theDialog.setTitle("<new property>");
        if (theDialog.getOK()) {
            this.theDataListener.registerChangedProperty(theDialog.getItskey(), theDialog.getItsvalue());
            this.listModel.addElement(theDialog.getItskey());
        }
        this.validate();
    }

    void viewButton_actionPerformed(ActionEvent e) {
        this.doView();
    }

    void contentList_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.doView();
        }
    }

    String filterEntry(String entry) {
        String result = "<?>";
        try {
            StringTokenizer stok = new StringTokenizer(entry, "=");
            result = (String)stok.nextElement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    void contentList_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.doView();
        }
        if (!this.editable) {
            return;
        }
        if (e.getKeyCode() == 155) {
            this.doAdd();
        }
        if (e.getKeyCode() == 127) {
            this.doDelete();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.viewButton.setBackground(Color.white);
        this.viewButton.setFont(new Font("Dialog", 0, 11));
        this.viewButton.setForeground(new Color(0, 0, 83));
        this.viewButton.setMinimumSize(new Dimension(13, 5));
        this.viewButton.setPreferredSize(new Dimension(13, 11));
        this.viewButton.setToolTipText("edit/view property");
        this.viewButton.setMargin(new Insets(0, 0, 0, 0));
        this.viewButton.setText("v");
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLPropertyList.this.viewButton_actionPerformed(e);
            }
        });
        this.addButton.setBackground(Color.white);
        this.addButton.setFont(new Font("Dialog", 0, 11));
        this.addButton.setForeground(new Color(0, 0, 83));
        this.addButton.setMinimumSize(new Dimension(13, 5));
        this.addButton.setPreferredSize(new Dimension(13, 11));
        this.addButton.setToolTipText("add property");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLPropertyList.this.addButton_actionPerformed(e);
            }
        });
        this.deleteButton.setBackground(Color.white);
        this.deleteButton.setFont(new Font("Dialog", 0, 11));
        this.deleteButton.setForeground(new Color(0, 0, 83));
        this.deleteButton.setMinimumSize(new Dimension(13, 5));
        this.deleteButton.setPreferredSize(new Dimension(13, 11));
        this.deleteButton.setToolTipText("delete property");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setText("x");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACLPropertyList.this.deleteButton_actionPerformed(e);
            }
        });
        this.contentList.setCellRenderer(this.aclPropertyListCellRenderer);
        this.contentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ACLPropertyList.this.contentList_keyPressed(e);
            }
        });
        this.contentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ACLPropertyList.this.contentList_mouseClicked(e);
            }
        });
        this.contentScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.contentScrollPane.getViewport().add((Component)this.contentList, null);
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewButton, new GridBagConstraints(1, 0, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class ACLPropertyListener
    implements ListDataListener {
        private String fieldName = "";
        private String theRemovedKey;
        private String theChangedKey;
        private String theChangedValue;
        private ACLMessage itsMsg;

        private ACLPropertyListener() {
        }

        public void register(Object obj, String fieldName) {
            this.itsMsg = (ACLMessage)obj;
            this.fieldName = fieldName;
        }

        public void intervalAdded(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            String key = (String)lm.elementAt(index);
            this.itsMsg.addUserDefinedParameter(this.theChangedKey, this.theChangedValue);
        }

        public void registerChangedProperty(String theChangedKey, String theChangedValue) {
            this.theChangedKey = theChangedKey;
            this.theChangedValue = theChangedValue;
        }

        public void registerRemovedKey(String theRemovedKey) {
            this.theRemovedKey = theRemovedKey;
        }

        public void intervalRemoved(ListDataEvent parm1) {
            String methodName = "remove" + this.fieldName;
            String theType = "jade.core.AID";
            this.itsMsg.removeUserDefinedParameter(this.theRemovedKey);
        }

        public void contentsChanged(ListDataEvent parm1) {
            DefaultListModel lm = (DefaultListModel)parm1.getSource();
            int index = parm1.getIndex0();
            this.itsMsg.removeUserDefinedParameter(this.theChangedKey);
            this.itsMsg.addUserDefinedParameter(this.theChangedKey, this.theChangedValue);
        }
    }

    private class ACLPropertyDialog
    extends JDialog {
        private String OK = "ok";
        private String CANCELLED = "cancelled";
        private String CLOSED = "closed";
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private JTextField keyTextField = new JTextField();
        private JLabel jLabel1 = new JLabel();
        private JButton okButton = new JButton();
        private JButton cancelButton = new JButton();
        private JLabel jLabel2 = new JLabel();
        private JTextField valueTextField = new JTextField();
        private String userAction;
        private String itsAddress;
        private String itskey;
        private String itsvalue;

        public ACLPropertyDialog() {
            this.setModal(true);
            try {
                this.jbInit();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String getUserAction() {
            return this.userAction;
        }

        public boolean getOK() {
            return this.userAction.equals(this.OK);
        }

        public String getItskey() {
            return this.itskey;
        }

        public String getItsvalue() {
            return this.itsvalue;
        }

        public void setEditable(boolean theBool) {
            if (!theBool) {
                this.OK = "CLOSED";
                this.cancelButton.setVisible(false);
                this.valueTextField.setEditable(false);
            }
        }

        public void setUserAction(String newUserAction) {
            this.userAction = newUserAction;
        }

        public void setItskey(String newItskey) {
            this.keyTextField.setText(newItskey);
            this.itskey = newItskey;
        }

        public void setEdit() {
            this.keyTextField.setEditable(false);
        }

        public void setItsvalue(String newItsvalue) {
            this.valueTextField.setText(newItsvalue);
            this.itsvalue = newItsvalue;
        }

        void jbInit() throws Exception {
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.jLabel1.setFont(new Font("Dialog", 0, 12));
            this.jLabel1.setText("key");
            this.getContentPane().setBackground(Color.white);
            this.okButton.setBackground(Color.white);
            this.okButton.setFont(new Font("Dialog", 0, 12));
            this.okButton.setText("ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ACLPropertyDialog.this.okButton_actionPerformed(e);
                }
            });
            this.cancelButton.setBackground(Color.white);
            this.cancelButton.setFont(new Font("Dialog", 0, 12));
            this.cancelButton.setText("cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ACLPropertyDialog.this.cancelButton_actionPerformed(e);
                }
            });
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jLabel2.setText("value");
            this.getContentPane().add((Component)this.keyTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.valueTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)this.okButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, -16, 0, 0), 0, 0));
        }

        void cancelButton_actionPerformed(ActionEvent e) {
            this.setUserAction(this.CANCELLED);
            this.hide();
        }

        void okButton_actionPerformed(ActionEvent e) {
            this.setItskey(this.keyTextField.getText());
            this.setItsvalue(this.valueTextField.getText());
            this.setUserAction(this.OK);
            this.hide();
        }
    }

    private class ACLPropertyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ACLMessage msg;

        public ACLPropertyListCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 11));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof String && this.msg != null) {
                String sValue = (String)value;
                String key = this.msg.getUserDefinedParameter(sValue);
                this.setText(sValue + " = " + key);
            }
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }

        public void register(ACLMessage msg) {
            this.msg = msg;
        }
    }
}

