/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PerDayFileLogger
extends PrintStream {
    private static final long DAY = 86400000L;
    private String file;
    private long dayCnt;
    private static DateFormat df = new SimpleDateFormat("yyyyMMdd");

    public PerDayFileLogger(String file) throws IOException {
        super(new FileOutputStream(file + "." + df.format(new Date()), true), true);
        this.file = file;
        this.dayCnt = System.currentTimeMillis() / 86400000L;
    }

    private void checkDate() {
        long n = System.currentTimeMillis() / 86400000L;
        if (n > this.dayCnt) {
            this.dayCnt = n;
            try {
                this.out.close();
                this.out = new FileOutputStream(this.file + "." + df.format(new Date()), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void print(Object obj) {
        this.checkDate();
        super.print(obj);
    }

    public void print(String str) {
        this.checkDate();
        super.print(str);
    }

    public void println() {
        this.checkDate();
        super.println();
    }

    public void println(Object obj) {
        this.checkDate();
        super.println(obj);
    }

    public void println(String str) {
        this.checkDate();
        super.println(str);
    }
}

