turtles-own
  [ sick?        ;; pokud m hodnotu true, tak je elva nemocn
    immune?      ;; pokud m hodnotu true, tak elva ji neme bt nakaena (je imunn)
    sick-count   ;; jak dlouho je elva nakaena
    age ]        ;; st elvy v tdnech
globals
[
  %infected            ;; jak procento populace je nakaeno 
  %immune              ;; jak procento populace je imunn
  lifespan             ;; prmrn dlka ivota elvy
  average-offspring    ;; prmrn mnostv potomk, kter me elva mt
  carrying-capacity    ;; maximln poet elv, kter me bt v jednu chvli v modelu 
]

;; Procedura tlatka Piprav je rozdlena do t okruh
to setup
  ca
  setup-constants
  setup-turtles
  update-plot
  update-global-variables
end

;; Nejdve vytvome promnnou pro poet elv, ze kterch 
;; bude 10 nakaench a nhodn je rozptlme
to setup-turtles
  set-default-shape turtles "person"
  crt pocet-lidi
    [ setxy random-xcor random-ycor
      set age random lifespan
      set sick-count 0
      set immune? false
      set size 1.5  ;; pro sna viditelnost
      ifelse (who < 10)
        [ get-sick ]
        [ get-healthy ] ]
end

to get-sick ;; procedura elv
  set sick? true
  set immune? false
  set color red
end

to get-healthy ;; procedura elv
  set sick? false
  set immune? false
  set sick-count 0
  set color green
end

to become-immune ;; procedura elv
  set sick? false
  set sick-count 0
  set immune? true
  set color gray
end

to setup-constants
  set lifespan 100
  set carrying-capacity 750
  set average-offspring 4
end

to go
  get-older
  move
  infect
  recover
  reproduce
  update-global-variables
  tick
  update-plot
end

to update-global-variables
  if count turtles > 0
  [
    set %infected (count turtles with [sick?]) / (count turtles) * 100
    set %immune (count turtles with [immune?]) / (count turtles) * 100
  ]
end

;; Natn asovch promnnch pro elvy
to get-older
  ask turtles
  [
    set age age + 1
    if sick?
      [ set sick-count (sick-count + 1) ]
     ;; elvy umrajc stm zemou dosaenm vku rovnmu 
     ;; konstant lifespan (v tomto modelu nastaveno na 100)
    if age > lifespan
      [ die ]
  ]
end

;; elvy se po svt pohybuj nhodn
to move
  ask turtles
  [ rt random 100
    lt random 100
    fd 1 ]
end

;; Pokud je elva nemon, nakaz ostatn elvy na stejnm polku
;; Imunn elvy se nenakaz
to infect
  ask turtles with [sick?]
    [ ask other turtles-here with [ not immune? ]
        [ if (random-float 100) < nakazlivost
            [ get-sick ] ] ]
end

;; Kdy u je elva dost dlouho nemocn,
;; tak se uzdrav (a stane se imunn) nebo zeme
to recover
   ask turtles with [sick?]
     [ if (random sick-count) > (lifespan * (trvani / 100))  ;; Pokud elva peila obdob trvn viru (nezemela vkem),
         [ ifelse ((random-float 100) < sance-uzdraveni)     ;; tak se uzdrav nebo zeme
             [ become-immune ]
             [ die ] ] ]
end
;; Pokud je v modelu mn elv, ne je hodnota konstanty
;; carrying-capacity, pak se elvy mohou reprodukovat. 
;; Pravdpodobnost reprodukce zvis na prmrnm mnostv
;; potomk (konstanta average-offspring). V tomto modelu jsou to 4 potomci 
;; (tedy 4 potomci za 100 tdn). Proto je ance, e se elva 
;; rozmno v jakmkoliv jednom konkrtnm kole, rovna 0.04 (pokud je 
;; populace pod hranic konstanty carrying-capacity).
to reproduce
  ask turtles with [not sick?]
    [ if (count turtles) < carrying-capacity
         and (random lifespan) < average-offspring
       [ hatch 1
           [ set age 1
             lt 45 fd 1
             get-healthy ] ] ]
end

to update-plot
  set-current-plot "Populace"
  set-current-plot-pen "nemocn"
  plot count turtles with [sick?]
  set-current-plot-pen "imunn"
  plot count turtles with [immune?]
  set-current-plot-pen "zdrav"
  plot count turtles with [not sick? and not immune?]
  set-current-plot-pen "celkem"
  plot count turtles
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1998 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1998).  NetLogo Virus model.
; http://ccl.northwestern.edu/netlogo/models/Virus.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Virus
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
284
10
749
496
17
17
13.0
1
10
1
1
1
0
1
1
1
-17
17
-17
17
1
1
1
ticks

CC-WINDOW
5
510
758
605
Command Center
0

SLIDER
31
172
225
205
trvani
trvani
0.0
99.0
20
1.0
1
tdn
HORIZONTAL

SLIDER
31
138
225
171
sance-uzdraveni
sance-uzdraveni
0.0
99.0
50
1.0
1
%
HORIZONTAL

SLIDER
31
104
225
137
nakazlivost
nakazlivost
0.0
99.0
65
1.0
1
%
HORIZONTAL

BUTTON
53
65
124
100
Piprav
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
129
65
200
101
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
6
257
261
421
Populace
tdny
poet lid
0.0
52.0
0.0
200.0
true
true
PENS
"nakaen" 1.0 0 -2674135 true
"imunn" 1.0 0 -7500403 true
"zdrav" 1.0 0 -10899396 true
"celkem" 1.0 0 -13345367 true

SLIDER
31
27
225
60
pocet-lidi
pocet-lidi
0
300
150
1
1
NIL
HORIZONTAL

MONITOR
17
208
109
253
%nakaench
%infected
1
1
11

MONITOR
101
208
175
253
%imunnch
%immune
1
1
11

MONITOR
177
208
240
253
roky
ticks / 52
1
1
11

@#$#@#$#@
CO TO JE?
-----------
Tento model simuluje penos a petrvn viru v lidsk populaci. Ekologit biologov navrhli nkolik faktor, kter mohou ovlivovat pevn bezprostedn penosnho viru v rmci populace (viz nap. Yorke a kol.). 

Na zatku je v modelu150 lid, ze kterch je 10 nakaench. Lid se nhodn pohybuj po svt ve tech monch stavech: zdrav, kte jsou ovem nchyln k nakaen (zelen), nemocn a infekn (erven), zdrav a imunn (ediv). Lid mohou umrat jak selost vkem, tak nsledkem nakaen. Pokud poet lid v populaci nepekro hranici "nosn kapacity" (v modelu nastavena na 700 osob), mohou se zdrav lid reprodukovat. Jejich potomky jsou zdrav lid s nchylnost k nakaen (zelen).

Nkter z faktor ovlivujcch petrvn a penos viru jsou shrnuty ne s vysvtlenm, jak jsou zahrnuty v tomto modelu.

Hustota populace
-----------------------------
Hustota populace ovlivuje frekvenci, s jakou pichz jednotlivci (nakaen, imunn i nchyln k nakaen) do vzjemnho kontaktu. Tento faktor lze ovlivnit zmnou velikosti poten populace pomoc nastaven POCET-LIDI.

Vmna generac
-------------------
Jednotlivci v populaci postupn umraj. Nkte z umrajcch jsou infekn, nkte jsou nchyln k nakaen a nkte jsou imunn. Vichni nov narozen jednotlivci, kte nahrazuj msto po zemelch, jsou nchyln k nakaen. Lid mohou umrat nsledkem st nebo vlivem viru. Pravdpodobnost mrt nsledkem nemoci lze ovlivnit nastavenm SANCE-UZDRAVENI. V tomto modelu umraj lid stm ve vku piblin 27 let. Mra reprodukce je v modelu konstantn. Kad kolo simulace maj vichni zdrav jedinci anci k vlastn reprodukci. Tato ance je u kadho jednotlivce nastavena tak, aby se v prmru za svj ivot tyikrt reprodukoval.

Mra imunity
------------------
Pokud se nakaen osoba uzdrav, do jak mry je pot imunn vi danmu viru? asto pedpokldme, e imunita trv cel ivot a funguje stoprocentn. V nkterch ppadech ovem imunita kles v prbhu asu a nemus tak zaruovat absolutn ochranu ped nakaenm. Nicmn v tomto modelu je imunita absolutn a celoivotn. 

Nakalivost
------------------------------------
Jak snadno se virus ? Nkter viry, kter bn znme, se  velmi jednodue. Existuj ovem i takov viry, kter se  vdy, a to i v ppad minimlnho kontaktu. Jin druhy (jako napklad virus HIV, kter zpsobuje AIDS) vyaduj del kontakt, asto i opakovan, aby dolo k penosu. V modelu je nakalivost pmo ovlivniteln stejnojmennm nastavenm. 

Trvn nkazy
--------------------------
Jak dlouho je jedinec nakaen, dokud se neuzdrav, nebo nezeme? Tento asov interval vyjaduje rozsah pleitosti pro penos viru na nov hostitele. V modelu je toto trvn pmo ovlivniteln pomoc pslunho nastaven.

JAK MODEL OVLDAT
-------------
Kad kolo reprezentuje v asovm mtku modelu jeden tden.

Nastaven  NAKAZLIVOST ovlivuje, s jakou pravdpodobnost dojde k penosu viru, pokud se na stejnm polku (patch) setk nakaen osoba s jednotlivcem nchylnm k nakaen. Kupkladu pokud m toto nastaven hodnotu 50, virus se roz piblin jednou bhem dvou tchto stetnut.

Nastaven TRVANI umouje stanovit obdob v prmrn dlce ivota (kter je v modelu zvolena na 1500 tdn, tedy piblin 27 let), kter trv od nakaen osoby do jejho vylen nebo mrt. Povimnte si, e pestoe lze hodnotu tohoto nastaven minimalizovat na hodnotu 0, bude v tomto ppad trvn nkazy sice velmi krtk (piblin 2 tdny), ale nebude zcela nulov.

Nastaven SANCE-UZDRAVENI ovlivuje pravdpodobnost, s jakou me infekce skonit uzdravenm nebo imunitou dan osoby. Pokud je hodnota tohoto nastaven rovna nule, je nkaza pokad smrteln.

Tlatko PIPRAV vytvo 140 zelench (nchylnch k nakaen) a 10 ervench (nakaench) nhodn rozptlench osob (rznho vku). Zrove je obnoveno vchoz nastaven okna simulace a grafu. Tlatko START zahajuje a ukonuje bh modelu a vynen sledovanch hodnot v grafu.  
  
Ti vstupn ukazatele umouj sledovat procentuln pomr nakaench a imunnch osob v populaci a tak poet let od sputn simulace. V grafu jsou (odpovdajcmi barvami) vyneny aktuln hodnoty pro mnostv dosud nenakaench, nakaench a imunnch. Zrove je zde mode vyznaena celkov velikost sledovan populace.

VIMNTE SI
--------------------
Faktory, ovldan tmito temi nastavenmi, na sebe navzjem psob a ovlivuj tak zpsob, jakm se virus rozvj v dan populaci. Povimnte si, e ve vech ppadech mus bt tyto faktory v rovnovze, pi kter zstane pro virus dostaten mnostv potencilnch hostitel a viru je umonn pstup k tmto hostitelm.

Na zatku simulace asto nastane prudk nrst nkazy, jeliko nikdo nen imunn a hustota populace je zrove maximln. To odpovd relnm potkm vypuknut virov infekce, kter asto vede k niivm dsledkm pro zasaen oblasti. Brzy se vak virus stv mn rozenm (v zvislosti na vvoji populan dynamiky). To, co se nakonec stane s virem, je ovlivnno faktory, kter jsou ovldny uvedenmi nastavenmi. 

Vimnte si, e virus, kter je zpotku pli spn (tm vechny osoby jsou nakaeny), nemus v dlouhodobm horizontu pet. Vzhledem k tomu, e vichni nakaen obvykle zemou, nebo se stanou imunnmi, je mnostv potencilnch hostitel asto omezen. Vjimku uveden tendence lze doshnout  nastavenm vysok hodnoty parametru TRVANI, dky kter dochz s pomoc pravideln reprodukce jednotlivc k peit viru, jeliko se zde v prbhu asu vytv dostatek novch hostitel.   

ZKUSTE SI
-------------
Promyslete, jak mohou hodnoty jednotlivch nastaven odpovdat dynamice relnho en viru. Znm virus Ebola ve stedn Africe ml kupkladu velmi krtk trvn, velmi vysok stupe nakalivosti a extrmn nzkou pravdpodobnost uzdraven. I pes veker obavy ped epidemickm rozenm tohoto viru lze pochybovat o tom, nakolik byl tento virus spn. Zkuste pizpsobit jednotliv nastaven tmto charakteristikm a sledujte, co se stane.

Virus HIV, kter zpsobuje smrtelnou nemoc AIDS, m extrmn dlouh trvn, extrmn nzkou anci k uzdraven, avak zrove velmi nzkou mru nakalivosti. Jak se bude chovat virus s tmito charakteristikami v naem modelu?

ROZEN MODELU
-------------------
Pidejte dal nastaven, kter by ovlivovala maximln poet lid (tedy celkov poet osob, kter mohou t v simulovanm svt v jeden okamik), a prmrnou dobu ivota jednotlivce. 

Vytvote obdobn model virov infekce pro jin hostitele viru ne je lovk, kte budou ovlivnni jinmi mrami reprodukce, dlky ivota a hustoty populace. 

Pidejte nastaven, ovlivujc dobu trvn imunity tak, aby tato imunita nebyla trval ani nefungovala stoprocentn. 

PODKOVN A ODKAZY
----------------------
Yorke a kol.: "Seasonality and the requirements for perpetuation and eradication of viruses in populations." Journal of Epidemiology, svazek 109, strany 103-123)

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Novak, M. and Wilensky, U. (2006).  NetLogo Virus model.  http://ccl.northwestern.edu/netlogo/models/Virus.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1997 Uri Wilensky.  All rights reserved.  
Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/Virus.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
