globals [
  percent-similar  ;; procento, vyjadujc kolik soused kad elvy
                   ;; je stejn barvy jako ona sama (v celkovm prmru)
  percent-unhappy  ;; mnostv nespokojench elv v procentech
]

turtles-own [
  happy?        ;; m hodnotu true (elva je spokojen), pokud m dan elva ve svm sousedstv alespo tolik
                ;; elv stejn barvy, kolik vyjaduje parametr pozadovane-%-stejnych (jinak m hodnotu false)
  similar-nearby   ;; kolik elv na sousednch polkch m stejnou barvu? 
  other-nearby  ;; kolik elv na sousednch polkch m jinou barvu?
  total-nearby  ;; souet pedchozch dvou promnnch
]


to setup
  clear-all
  if pocet-zelv > count patches
    [ user-message (word "Do tohoto prostoru se vejde pouze " count patches " elv.")
      stop ]

  ;; vytvo a nhodn rozptl elvy po polkch
  ask n-of pocet-zelv patches
    [ sprout 1
      [ set color red ] ]
  ;; polovin elv zmn barvu z erven na zelenou
  ask n-of (pocet-zelv / 2) turtles
    [ set color green ]
  update-variables
  do-plots
end

to go
  if all? turtles [happy?] [ stop ]
  move-unhappy-turtles
  update-variables
  tick
  do-plots
end

to move-unhappy-turtles
  ask turtles with [ not happy? ]
    [ find-new-spot ]
end

to find-new-spot
  rt random-float 360
  fd random-float 10
  if any? other turtles-here
    [ find-new-spot ]          ;; pokrauj, dokud nenajde voln polko
  move-to patch-here  ;; posu se do stedu polka
end

to update-variables
  update-turtles
  update-globals
end

to update-turtles
  ask turtles [
    ;; v nsledujcch pkazech pouvme vrazu "neighbors" k otestovn
    ;; sousednch osmi polek, kter obklopuj pslun polko s elvou
    set similar-nearby count (turtles-on neighbors)
      with [color = [color] of myself]
    set other-nearby count (turtles-on neighbors)
      with [color != [color] of myself]
    set total-nearby similar-nearby + other-nearby
    set happy? similar-nearby >= ( pozadovane-%-stejnych * total-nearby / 100 )
  ]
end

to update-globals
  let similar-neighbors sum [similar-nearby] of turtles
  let total-neighbors sum [total-nearby] of turtles
  set percent-similar (similar-neighbors / total-neighbors) * 100
  set percent-unhappy (count turtles with [not happy?]) / (count turtles) * 100
end

to do-plots
  set-current-plot "Procento stejnch"
  plot percent-similar
  set-current-plot "Procento nespokojench"
  plot percent-unhappy
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant pocet-zelvs RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant pocet-zelvs REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo Segregation model.
; http://ccl.northwestern.edu/netlogo/models/Segregation.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1997 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Segregation
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
374
21
763
431
25
25
7.4314
1
10
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks

CC-WINDOW
5
445
772
540
Command Center
0

MONITOR
268
326
367
371
% nespokojench
percent-unhappy
1
1
11

MONITOR
268
173
367
218
% stejnch
percent-similar
1
1
11

PLOT
13
141
262
284
Procento stejnch
as
%
0.0
5.0
0.0
100.0
true
false
PENS
"percent" 1.0 0 -2674135 true

PLOT
12
286
261
429
Procento nespokojench
as
%
0.0
5.0
0.0
100.0
true
false
PENS
"percent" 1.0 0 -10899396 true

SLIDER
19
22
231
55
pocet-zelv
pocet-zelv
500
2500
2000
10
1
NIL
HORIZONTAL

SLIDER
19
95
231
128
pozadovane-%-stejnych
pozadovane-%-stejnych
0
100
30
1
1
%
HORIZONTAL

BUTTON
48
58
128
91
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
129
58
209
91
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
CO TO JE?
-----------
Tento model zkoum chovn dvou typ elv v jezrku. erven a zelen elvy spolu dobe vychz. Kad elva se chce ovem ujistit, e ije pobl elvy stejnho druhu. To znamen, e kad erven elva chce t v blzkosti nejmn jedn erven elvy a kad zelen elva chce t v blzkosti alespo njak zelen elvy. Simulace ukazuje, jak tyto individuln preference "zamchaj" jezrkem a vedou tak k celkov zmn jeho struktury.

Projekt byl inspirovn prac Thomase Schellinga o spoleenskch systmech. Schelling studoval zkonitosti, zabydlovn mst, zejmna ho zajmalo, pro se maj rzn rasy i nrodnosti tendenci segregovat (tj. rozdlovat do shluk), i kdy mezi sebou docela dobe vychz. 

JAK MODEL OVLDAT
-------------
Kliknte na tlatko PIPRAV k rozmstn elv v jezrku. Poet ervench a zelench elv je shodn. elvy se budou pohybovat tak, aby na jednom polku byla nanejv jedna elva. Tlatko START  zahajuje a ukonuje bh modelu. Pokud elvy nemaj ve svm sousedstv dostatek jinch elv stejn barvy, pemst se na nejbli voln polko. 

Nastavenm POCET-ZELV lze ovldat celkov mnostv elv v jezrku. (Zmna tohoto nastaven se projev a pi ptm kliknutm na tlatko PIPRAV.) Nastaven POZADOVANE-%-STEJNYCH uruje procento elv stejn barvy, kter elvy poaduj ve svm okol. Kupkladu nastaven tohoto parametru na 30 znamen, e kad zelen elva chce mt nejmn 30 % zelench elv mezi svmi sousedy. 

Ukazatel % STEJNCH ukazuje prmrn procento soused stejn barvy vech elv. Tento ukazatel zan kolem hodnoty 50 %, jeliko kad elva zan (v prmru) se stejnm potem zelench a ervench elv mezi svmi sousedy. Ukazatel % NESPOKOJENCH ukazuje procentuln mnostv elv, kter maj ve svm okol mn elv stejnho druhu, ne poaduj (a proto chtj zmnit pozici). Hodnoty obou ukazatel v ase jsou tak vyneny v grafech. 

VIMNTE SI
----------------
Po stisknut tlatka PIPRAV jsou zelen a erven elvy nhodn rozmstny v prostoru jezrka. V tomto okamiku je ovem mnoho elv nespokojench se svou pozic, protoe nemaj dostatek soused stejn barvy. Nespokojen elvy se tedy pemst na novou pozici ve svm nejblim okol. Na tto nov pozici mohou ovem zmnit rovnovhu lokln populace, co me vst k dal nespokojenosti a pohybu ostatnch elv. Pokud se nkolik ervench elv pesune do njak oblasti, mohou tak zpsobit odchod ptomnch zelench elv. Pokud se naopak nkam pemst zelen elvy, me bt dsledkem lokln odchod ervench elv.

V prbhu asu poet nespokojench elv postupn kles. Na druhou stranu zan bt jezrko vce segregovno, jeliko vznikaj shluky elv zelen nebo erven barvy.   

V ppad, e kad elva poaduje ve svm okol alespo 30 % soused stejn barvy, je na konci simulace tato elva obklopena (v prmru) kolem 70 % stejn barevnch soused. Relativn nzk rovn individulnch preferenc tak mohou vst k vrazn celkov segregaci. 

ZKSUTE SI
-------------
Vyzkouejte odlin hodnoty pro nastaven POZADOVANE-%-STENYCH. Jakm zpsobem se v dsledku tohoto nastaven zmn konen stupe segregace?

Pokud kad elva poaduje ve svm okol nejmn 40 % soused stejn barvy, s jakm (prmrnm) procentem tchto soused zstane na konci simulace?

ROZEN MODELU
-------------------
Zakomponujte do modelu sociln st. Nespokojen elvy se mohou napklad rozhodovat o pesunu na nov msto na zklad informac o sousedech na tomto mst od ostatnch elv v jejich sociln sti. 

Zmte pravidla pro uren spokojenosti elv. Jednou z monost je pedpoklad, e elvy budou ke sv spokojenosti vyadovat ve svm okol jistou minimln prahovou hodnotu "dobrch soused". Dle uvaujme, e elvy nemus pokad vdt, zdali je njak elva dobrm sousedem i nikoliv. Pokud tuto informaci elvy maj, pak ji pi svm rozhodovn pouij. Pokud ji vak nemaj, pouij jako nhradn kritrium barvu -- tedy boudou pedpokldat, e elvy stejn barvy jsou dobrmi sousedy.

PROGRAMOVAC ZAJMAVOSTI NETLOGA
----------------
V kdu je vyuito primitivum N-OF a SPROUT k zajitn toho, aby na jednom polku nebyla vce ne jedna elva.

Pi pohybu elv je dle pouito MOVE-TO k pesunu elvy na sted nov nalezenho polka.

PODKOVN A ODKAZY
----------------------
Schelling, T. (1978). Micromotives and Macrobehavior. New York: Norton.
Viz tak lnek v asopise Atlantic:   Rauch, J. (2002). Seeing Around Corners; The Atlantic Monthly; April 2002;Volume 289, No. 4; 35-48. http://www.theatlantic.com/issues/2002/04/rauch.htm

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz: Wilensky, U. (1997). NetLogo Segregation model.  http://ccl.northwestern.edu/netlogo/models/Segregation. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace: Copyright 1997 Uri Wilensky. All rights reserved. Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/Segregation.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
