globals [
  infection-chance  ;; Procentuln vyjden ance, e dojde k penosu viru na zdravho jedince
                    ;; bhem jednoho tdne (asovho kroku) partnerskho vztahu
  symptoms-show     ;; Doba za kterou se od chvle nakaen objev symptomy nemoci, 
                    ;; co nsledn vede k nvtv HIV test a identifikaci nkazy
                    
  slider-check-1    ;; Doasn pomocn promnn pro hodnoty posuvnk.
  slider-check-2    ;; Slou k tomu, aby se zmny hodnot posuvnk za bhu 
  slider-check-3    ;; simulace promtly bezprostedn do modelu
  slider-check-4
]

turtles-own [
  infected?          ;; Pokud je true, pak je osoba infikovna virem. O nkaze dan osoba me vdt nebo nevdt
  known?             ;; Pokud je true, pak o infekci v (ale hodnota "infected" mus bt tak true)
  infection-length   ;; Jak dlouho je nakaena
  coupled?           ;; Pokud je true, pak m prov sexuln vztah
  couple-length      ;; Jak dlouho u je v pru
  ;; nsledujc tyi promnn jsou ovldny posuvnky v uivatelskm rozhrann modelu
  commitment         ;; Jak dlouho zstane dan osoba ve vztahu
  coupling-tendency  ;; Jak moc se chce provat
  condom-use         ;; Procentuln ance, e pouije ochranu
  test-frequency     ;; Poet HIV test, kter za rok navtv
  partner            ;; Osoba, kter je protjkem jedince v aktulnm pru
]

;;;
;;; PROCEDURY TLATKA PIPRAV
;;;

to setup
  ca
  setup-globals
  setup-people
  setup-plot
  update-plot
end

to setup-globals
  reset-ticks
  set infection-chance 50    ;; Pokud jsi ml nechrnn sex s nakaenm partnerem,
                             ;; m 50% anci, e se sm nakaz
  set symptoms-show 200.0    ;; Symptomy se projev 200 tdn po nkaze
  set slider-check-1 prumerna-delka-vztahu
  set slider-check-2 prumerny-sklon-k-parovani
  set slider-check-3 prumerne-pouzivani-kondomu
  set slider-check-4 prumerna-frekvence-testovani
end

 ;; Vytvo poten mnostv lid, kde polovina bude bude mt tvar "person lefty", polovina "person righty"
 ;; a nkte jedinci budou navc nakaen. Dle piad lidem barvy podle procedury ASSIGN-COLORS.
to setup-people
  crt pocet-lidi
    [ setxy random-xcor random-ycor
      set known? false
      set coupled? false
      set partner nobody
      ifelse random 2 = 0
        [ set shape "person righty" ]
        [ set shape "person lefty" ]
      ;; Na zatku bhu modelu je 2.5% populace nakaeno, ale nev o tom
      set infected? (who < pocet-lidi * 0.025)
      if infected?
        [ set infection-length random-float symptoms-show ]
      assign-commitment
      assign-coupling-tendency
      assign-condom-use
      assign-test-frequency
      assign-color ]
end

;; Jsou zde ti skupiny lid, odlien barvami podle svho zdravotnho stavu.
;; Zelen nejsou nakaen, mod jsou nakaen, ale nev o tom a 
;; erven jsou nakaen a vd o tom


to assign-color  ;; procedura elv
  ifelse not infected?
    [ set color green ]
    [ ifelse known?
      [ set color red ]
      [ set color blue ] ]
end

;; Nsledujc tyi procedury piazuj elvm hodnoty klovch promnnch. 
;; Je zde pouita pomocn procedura RANDOM-NEAR, aby byly elvm piazeny hodnoty
;; piblin podle normlnho rozdlen v zvislosti na nastaven posuvnk (prmry)


to assign-commitment  ;; procedura elv
  set commitment random-near prumerna-delka-vztahu
end

to assign-coupling-tendency  ;; procedura elv
  set coupling-tendency random-near prumerny-sklon-k-parovani
end

to assign-condom-use  ;; procedura elv
  set condom-use random-near prumerne-pouzivani-kondomu
end

to assign-test-frequency  ;; procedura elv
  set test-frequency random-near prumerna-frekvence-testovani
end

to-report random-near [center]  ;; procedura elv
  let result 0
  repeat 40
    [ set result (result + random-float center) ]
  report result / 20
end

;;;
;;; PROCEDURY TLATKA START
;;;

to go
  if all? turtles [known?]
    [ stop ]
  check-sliders
  ask turtles
    [ if infected?
        [ set infection-length infection-length + 1 ]
      if coupled?
        [ set couple-length couple-length + 1 ] ]
  ask turtles
    [ if not coupled?
        [ move ] ]
  ;; Osoby s tvarem "person righty" vdy dvaj podnt k provn
  ;; Jedn se o arbitrrn volbu, kter usnaduje implementaci kdu
  ask turtles
    [ if not coupled? and shape = "person righty" and (random-float 10.0 < coupling-tendency)
        [ couple ] ]
  ask turtles [ uncouple ]
  ask turtles [ infect ]
  ask turtles [ test ]
  ask turtles [ assign-color ]
  tick
  update-plot
end

 ;; V kadm asovm kroku je provedena kontrola, zda se nezmnily hodnoty ovldan posuvnky
 ;; Pokud nastalala zmna, jsou podle n ovlivnny i odpovdajc hodnoty promnnch u elv

to check-sliders
  if (slider-check-1 != prumerna-delka-vztahu)
    [ ask turtles [ assign-commitment ]
      set slider-check-1 prumerna-delka-vztahu ]
  if (slider-check-2 != prumerny-sklon-k-parovani)
    [ ask turtles [ assign-coupling-tendency ]
      set slider-check-2 prumerny-sklon-k-parovani ]
  if (slider-check-3 != prumerne-pouzivani-kondomu)
    [ ask turtles [ assign-condom-use ]
      set slider-check-3 prumerne-pouzivani-kondomu ]
  if (slider-check-4 != prumerna-frekvence-testovani )
    [ ask turtles [ assign-test-frequency ]
      set slider-check-4 prumerna-frekvence-testovani ]
end


;; Lid se po svt pohybuj nhodn

to move  ;; procedura elv
  rt random-float 360
  fd 1
end

;; Jedinci, pokud nkoho potkaj, maj v zvislosti na jejich sklonu k sexulnm aktivitm anci na utvoen pru. 
;; Aby bylo lpe vidt, e se jedn o pr, polko pod obma osobami zmn barvu na edou


to couple   ;; procedura elv - pouze s tvarem "person righty"
  let potential-partner one-of (turtles-at -1 0)
                          with [not coupled? and shape = "person lefty"]
  if potential-partner != nobody
    [ if random-float 10.0 < [coupling-tendency] of potential-partner
      [ set partner potential-partner
        set coupled? true
        ask partner [ set coupled? true ]
        ask partner [ set partner myself ]
        move-to patch-here ;; posu se na sted polka
        move-to patch-here ;; partner se tak posune na sted polka
        set pcolor gray - 3
        ask (patch-at -1 0) [ set pcolor gray - 3 ] ] ]
end

 ;; Pokud dlka vztahu pekro hodnotu odpovdajc promnn 
 ;; jednoho z partner, dojde k ukonen sexulnho vztahu.

to uncouple  ;; procedura elv
  if coupled? and (shape = "person righty")
    [ if (couple-length > commitment) or
         ([couple-length] of partner) > ([commitment] of partner)
        [ set coupled? false
          set couple-length 0
          ask partner [ set couple-length 0 ]
          set pcolor black
          ask (patch-at -1 0) [ set pcolor black ]
          ask partner [ set partner nobody ]
          ask partner [ set coupled? false ]
          set partner nobody ] ]
end

 ;; Osoba me bt nakaen, avak nemus o svm zdravotnm stavu vdt.
 ;; Tento model pedpokld, e lid, kte vd o sv nkaze, dl pokrauj v
 ;; provn, avak praktikuj pouze bezpen sex, bez ohledu na jejich pedchzejc 
 ;; sklon k pouvn kondom. Vimnte si tak, e oba partnei mus souhlasit s pouitm kondomu.
 ;; Pokud jeden z partner nesouhlas, neprovozuj bezpen sex a je zde tedy nsledn riziko nkazy.
 ;; Zmna primitiva OR na AND ve tet dce procedury zpsob, e pro bezpen sex bude 
 ;; stait, aby kondom chtl pout pouze jeden z partner

to infect  ;; procedura elv
  if coupled? and infected? and not known?
    [ if random-float 11 > condom-use or
         random-float 11 > ([condom-use] of partner)
        [ if random-float 100 < infection-chance
            [ ask partner [ set infected? true ] ] ] ]
end

;; Lid maj sklon chodit na testy HIV podle hodnoty odpovdajcho posuvnku.
;; Tento sklon je v procedue porovnn s nhodnm slem. Po jistm ase, kter odpovd
;; hodnot SYMPTOM-SHOW je zde ale 5% ance, e se u dan osoby projev symptomy onemocnn 
;; a jedinec nsledn bezprostedn navtv zdravotn prohldku (bez ohledu na jeho sklon 
;; k nvtevnosti test), kter pot odhal ptomnost viru.

to test  ;; procedura elv
  if random-float 52 < test-frequency
    [ if infected?
        [ set known? true ] ]
  if infection-length > symptoms-show
    [ if random-float 100 < 5
        [ set known? true ] ]
end

;;;
;;; PROCEDURY GRAFU
;;;

to setup-plot
  set-current-plot "Populace"
  set-plot-y-range 0 (pocet-lidi + 50)
end

to update-plot
  set-current-plot "Populace"
  set-current-plot-pen "HIV-"
  plot count turtles with [not infected?]
  set-current-plot-pen "HIV?"
  plot count turtles with [infected?] -
       count turtles with [known?]
  set-current-plot-pen "HIV+"
  plot count turtles with [known?]
end

;;;
;;; PROCEDURY UKAZATELE
;;;

to-report %infected
  ifelse any? turtles
    [ report (count turtles with [infected?] / count turtles) * 100 ]
    [ report 0 ]
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo AIDS model.
; http://ccl.northwestern.edu/netlogo/models/AIDS.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1997 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/AIDS
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
289
12
724
468
12
12
17.0
1
10
1
1
1
0
1
1
1
-12
12
-12
12
1
1
1
weeks

CC-WINDOW
5
482
733
577
Command Center
0

BUTTON
12
81
95
114
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
96
81
179
114
Start
go\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
184
74
279
119
% nakaench
%infected
2
1
11

SLIDER
7
37
276
70
pocet-lidi
pocet-lidi
50
500
300
1
1
NIL
HORIZONTAL

SLIDER
7
162
276
195
prumerna-delka-vztahu
prumerna-delka-vztahu
1
200
50
1
1
weeks
HORIZONTAL

SLIDER
7
127
276
160
prumerny-sklon-k-parovani
prumerny-sklon-k-parovani
0
10
5
1
1
NIL
HORIZONTAL

SLIDER
7
197
276
230
prumerne-pouzivani-kondomu
prumerne-pouzivani-kondomu
0
10
0
1
1
NIL
HORIZONTAL

SLIDER
7
232
277
265
prumerna-frekvence-testovani
prumerna-frekvence-testovani
0
2
0.01
0.01
1
times/year
HORIZONTAL

PLOT
7
268
276
467
Populace
tdny
poet lid
0.0
52.0
0.0
350.0
true
true
PENS
"HIV-" 1.0 0 -10899396 true
"HIV+" 1.0 0 -2674135 true
"HIV?" 1.0 0 -13345367 true

@#$#@#$#@
CO TO JE?
-----------
Toto je model en viru HIV sexuln cestou v rmci men izolovan skupiny lid. Ilustruje tak dsledky sexulnch kontakt v rmci populace. Jak je znmo, HIV se  vce rznmi zpsoby, piem sexuln kontakt je pouze jednm z nich. Virus me bt penen tak spolenm pouvnm jehel mezi uivateli drog, krevn transfz (co se stv zdka, jeliko ve vysplch sttech jako napklad v USA je krev skenovna pro zjitn ptomnosti HIV protiltek), nebo penosem z matky nakaen virem HIV na dt v prbhu thotenstv, pi porodu nebo pi kojen. Tento model se zamuje pouze na en viru cestou sexulnho kontaktu. Model zkoum, jak jsou inky ty rznch aspekt sexulnho chovn. Uivatel ovld tendenci populace k sexuln abstinenci, dobu, kterou prmrn pr strv ve vztahu, tendenci populace k pouvn kondom a nakonec tak frekvenci HIV testovn. Zkoumnm prvnch dvou parametr meme zjistit, jak aktuln pevaujc sexuln chovn pispv k rozen sexuln penosnch chorob, zatmco tet a tvrt parametr pedstavuj een tohoto problmu.

Tm, e lze ovldat frekvenci, s jakou jsou jedinci testovni, je uivateli umonno zkoumat dleit rozmr ohroen zdrav populace virem HIV. Jeliko se ve svm hostiteli virus neprojev hned, jedinci jsou asto nakaeni ji njakou dobu pedtm, ne se jejich nkaza projev v testech nebo se rozvinou pznaky choroby (co vede k tomu, e se nech jedinec testovat) a jsou oznaeni jako HIV pozitivn. Povinn identifikace jedinc nakaench virem me mt vznamn dopad na zdrav populace, pokud obeznmenost s nkazou pozitivn ovlivn sexuln chovn ve spolenosti. Tento model vychz z pedpokladu, e vichni jedinci, kte vd, e jsou HIV pozitivn, vdy praktikuj pouze bezpen sex.

JAK MODEL OVLDAT
-------------
V modelu je vyuito termnu pr (resp. provn) k popisu dvou lid, kte mezi sebou udruj sexuln vztah. Jednotliv lid se pohybuj po svt, pokud nejsou v pru. Pokud ovem jedinec potk vhodnho partnera, je zde ance, e spolu vytvo pr. Pokud se tak stane, tito dva jedinci se pestanou pohybovat a zstanou v modelu stt vedle sebe, drc se vzjemn za ruku (symbolick vyjden sexulnho vztahu mezi dvma lidmi). Ptomnost viru v populaci je reprezentovna barvami jedinc. Jsou zde pouity ti barvy: zelen (nenakaen jedinci), modr (nakaen, kte nevd o sv nkaze) a erven (nakaen, kte znaj svj stav). Tlatko PIPRAV vytvo mnoinu jedinc s uritmi sklony chovn podle toho, jak jsou hodnoty pti posuvnk v uivatelskm rozhrann (viz ne). Jakmile je model nastaven, je mon jej spustit tlatkem START. Tlatko START spust bh modelu na tak dlouho, dokud nebude znovu stisknuto. Uvedenmi pti posuvnky je mon mnit sklony chovn populace i v prbhu simulace.

Ukazatel vedle zmnnch tlatek znzoruje procento populace, kter je infikovno HIV. V modelu slou kad asov krok k vyjden jednoho tdne; poet uplynulch tdn je zobrazen v doln sti lity okna modelu. Zde je seznam posuvnk, kter jsou soust modelu. Jejich funkce je ble vysvtlena v nsledujcm textu:
- POCET-LIDI: Kolik lid na zatku model obsahuje.
- PRUMERNY-SKLON-K-PAROVANI: Sklon lena spolenosti k sexulnm aktivitm (010).
- PRUMERNA-DELKA-VZTAHU: Kolik tdn bn trv sexuln vztah (0200).
- PRUMERNE-POUZIVANI-KONDOMU: Pravdpodobnost, s jakou jedinec pouije kondom (010).
- PRUMERNA-FREKVENCE-TESTOVANI: Prmrn frekvence, vyjadujc, jak asto len spolenosti chod na testy HIV v rmci jednoho roku?(02). 

Celkov poet jedinc v modelu je ovldn posuvnkem POCET-LIDI (pipraven pro rozmez 50500 osob), kter mus bt jednoznan nastaven ped stisknutm tlatka PIPRAV.

V prbhu procedur tlatka PIPRAV jsou vem jedincm piazeny jednotliv sklony podle dalch ty posuvnk. Tyto sklony jsou jednotlivm osobm pidleny podle normlnho rozdlen, co znamen, e pokud je napklad posuvnk danho sklonu nastaven na hodnotu 8, nejastj hodnota pro tento sklon u jedinc v populaci bude 8. Men st populace bude mt hodnoty 7 nebo 9 a jet men st jich bude mt hodnoty 6 nebo 10 (a tak dle). 

Posuvnk PRUMERNY-SKLON-K-PAROVANI (010) ovlivuje sklon len spolenosti k vytvoen provho vztahu (jak ji bylo eeno dve, vechny tyto vztahy zjednoduen povaujeme za sexuln aktivn). Pokud je tento posuvnk nastaven na nulu, provn je nepravdpodobn, pesto je vak stle mon (prv kvli normlnmu rozdlen zmnnmu ve). Pokud se rozhoduje o zapoet provho vztahu, mus to chtt oba jedinci, co znamen, e se sklony obou osob skldaj dohromady (pokud se napklad setkaj dva jedinci s 50% anc k provn, maj spolenou anci k vytvoen pru pouze 25% v jednom asovm kroku).

Posuvnk PRUMERNA-DELKA-VZTAHU (1200) uruje dobu, po kterou jedinci zstanou v pru (vyjdeno v tdnech). Opt se bere v vahu sklon obou osob; vztah trv tak dlouho, jak si peje partner se sklonem ke krat dob vztahu.

Posuvnk PRUMERNE-POUZIVANI-KONDOMU (010) ovlivuje sklon populace k provozovn bezpenho sexu. Pokud jedinec pouv kondom, pedpokld se, e neme bt nakaen HIV. Vimnte si, e tento sklon je (podobn jako ostatn) pouze piblin. Tak napklad, pokud PRUMERNE-POUZIVANI-KONDOMU je nastaveno na 9, vtina jedinc bude mt hodnotu tto promnn 9, pesto vak nkte jedinci mohou mt hodnotu 8 nebo 10 a nkolik osob dokonce bude mt hodnoty 7 nebo 11 (hodnota 11 bude kvli pekroen intervalu srovnna na maximln hodnotu 10). Jedinec s hodnotou 9 obas kondom nepouije (konkrtn v 10 % ppad). Modelovn pouvn kondom je dle komplikovno tm, e pokud jeden partner chce pout kondom a druh ne, pr ve vsledku kondom nepouije. Tato charakteristika modelu odpovd dynamice pouze nkterch sexulnch vztah. Rozhodnut pro zaveden tto charakteristiky bylo veskrze arbitrrn a uivatel m monost toto omezen spolu s jinmi voln zmnit podle instrukc v sti ROZEN MODELU.

Posuvnk PRUMERNA-FREKVENCE-TESTOVANI (02) je poslednm posuvnkem rozhrann modelu. Uruje, jak asto se jedinec podrobuje testm na HIV v prbhu jednoho roku. Nastaven hodnoty 1.0 znamen, e prmrn osoba pjde na testy jednou za rok. Nastaven 0.2 vyjaduje, e prmrn jedinec se podrob HIV testm pouze jednou za pt let. Tento sklon m vznamn dopad, nebo osoby, kter vd o sv nkaze, vdy praktikuj bezpen sex, i pestoe, dokud byly zdrav, mohly bt jejich tendence k pouvn ochrany odlin. Opt, tato charakteristika vyjaduje chovn pouze nkterch jedinc. Model byl takto vytvoen proto, aby ukzal vznam dopad na zdrav populace, kter souvis s astm testovnm a s vhodnm chovnm pi obeznmenosti s nkazou partnera. Pro zkoumn dopad jinch alternativ chovn na zdrav populace lze kd pomrn jednodue pozmnit. Tyto zmny jsou popsny v sekci ROZEN MODELU.

V grafu je v prbhu modelu vykreslovn celkov poet nenakaench jedinc (zelen), nakaench jedinc, kte jet o viru nevd (modr), a nakaench, kte jsou obeznmeni se svm HIV pozitivnm stavem (erven).

VIMNTE SI
----------------
Nastavte hodnotu posuvnku POCET-LIDI na 300, PRUMERNY-SKLON-K-PAROVANI na 10, PRUMERNA-DELKA-VZTAHU na 100 a zbytek posuvnk na 0. Stisknte tlatko PIPRAV a nsledn tlatko START. Vimnte si, e se vznamn st jedinc brzy vytvo pry a polka na jejich pozad zmn barvu na edou. Tyto pry reprezentuj sexuln aktivitu mezi partnery. Jedinci, kte se i nadle pohybuj (a nemaj za sebou ed polko), nejsou soust dnho sexulnho vztahu. S nastavenm PRUMERNA-DELKA-VZTAHU na hodnotu 100 bude mt prmrn jedinec monogamn sexuln vztah s partnerem po dobu zhruba 100 tdn (piblin 2 roky), ne se vztah rozpadne a partnei zanou hledat nov protjky.

Zastavte bh modelu (optovnm stisknutm tlatka START), posute hodnotu posuvnku PRUMERNY-SKLON-K-PAROVANI na 0, stisknte tlatko PIPRAV a spuste simulaci znovu (tlatkem START). Vimnte si, e tentokrt se pry netvo. S nzkou hodnotou zmnnho parametru nejev jedinci zjem o sexuln aktivity, co je v modelu znzornno absenc pr. Tak si vimnte, e pi tomto nastaven se zpravidla HIV ne. Pesto me k penosu viru dojt, nebo sklony len populace odpovdaj normlnmu rozdlen, a tm pdem budou mt nkte jedinci hodnotu sklonu k provn vy ne 0.

Spuste znovu simulaci tentokrt s posuvnkem PRUMERNY-SKLON-K-PAROVANI zptky na hodnot 10 a s posuvnkem PRUMERNA-DELKA-VZTAHU na hodnot 1. Pestoe pi tto rychlosti spolu pry zstvaj po sotva postehnutelnou dobu, dochz pesto k jejich vytven. To je v modelu reprezentovno krtkmi zblesky ed barvy v pozad jedinc, kte spolu po krtkou dobu udruj sexuln kontakt. Vimnte si, e v tomto ppad je en viru mnohem rychlej ne v ppad s dlouhodob trvajcmi vztahy. Nyn spuste bh modelu s hodnotou PRUMERNA-DELKA-VZTAHU na 1, PRUMERNY-SKLON-K-PAROVANI na 1, PRUMERNE-POUZIVANI-KONDOMU nastavte na 10 a PRUMERNA-FREKVENCE-TESTOVANI na 1.0. Se slabm sklonem k provn a vysokm stupnm pouvn ochrany by nemlo dochzet k dnmu en HIV.

Vimnte si, e mod jedinci v modelu ervenaj vrazn rychleji ne v jinch ppadech. Kdy zervenaj, je znm jejich HIV pozitivn stav. Nkte jedinci zervenaj, nebo se jejich nemoc projev svmi symptomy, na zklad kterch se nechaj testovat. Ostatn zervenaj dky prokzn HIV v prbhu testovn. S hodnotou PRUMERNA-FREKVENCE-TESTOVANI nastavenou na 1.0 jsou testovn i zdrav jedinci, ovem jejich barva se nezmn, pokud jsou vsledky testu negativn.

Ve chvli, kdy budou v modelu ptomn pouze zelen a erven jedinci, zmte hodnoty posuvnk bez zastaven simulace. Nastavte PRUMERNY-SKLON-K-PAROVANI na 10, PRUMERNA-DELKA-VZTAHU na 100, PRUMERNE-POUZIVANI-KONDOMU na 0 a PRUMERNA-FREKVENCE-TESTOVANI na 0. Vimnte si, e navzdory rychlmu provn, nzkmu sklonu k pouvn ochrany a tomu, e nkte jedinci jsou nakaen, nedochz k en HIV. Je tomu tak proto, e v modelu pedpokldme, e nakaen jedinci vdy pouij ochranu, kter bude navc ve vech ppadech spolehliv. Odvodnn tto charakteristiky je diskutovno ve v sekci CO TO JE?.

Nakonec nastavte posuvnk POCET-LIDI na hodnotu 500 a vimnte si, e pry se mohou vytvoit na stejnm polku, na kterm u jin pr stoj. Pozorujte bh modelu, dokud neuvidte samotn jedince s edm pozadm. Za tmito jedinci jsou zakryti jejich partnei. Jedn se o nutnou chybu v programu, nebo bylo nutn zajistit, aby byl pohyb jedinc v modelu zcela voln (a mohli se tedy i vzjemn pekrvat). Pokud by prostorov zbrany omezovaly provn, mohlo by dojt k emergenci nedanch jev, zkreslujcch chovn modelu.

Pry jsou graficky v modelu formovny z tvar (turte shapes) person lefty (postavika umstna v lev sti polka) a person righty (postavika v prav sti polka), co na prvn pohled nen patrn. Tyto tvary nemaj nikterak vyjadovat rozdlnost pohlav, nbr poskytuj vhodn nstroj ke grafickmu oddlen pr vzjemn mezi sebou. Kdyby nebylo tohoto nastaven, dochzelo by k tomu, e dva pry stojc vedle sebe by se jevily jako spojen tveice, msto toho, aby byly rozliiteln jako dv oddlen dvojice. Nen zde tedy snaha vyjdit tvarem postaviky pohlav, nebo za kad z obou tvar lze dosadit jak mue, tak i enu.

ZKUSTE SI
-------------
Spuste experiment tlatkem START s rznmi nastavenmi posuvnk a experimentujte s dopadem tchto parametr na en HIV v populaci. Zkuste si clen ovldn experimentu. Clen ovldn znamen, e mnte mezi jednotlivmi bhy modelu pouze jednu promnnou. Napklad pro zkoumn vlivu prmrn dlky sexulnho vztahu puste postupn tyi experimenty  nejdve s hodnotou PRUMERNA-DELKA-VZTAHU 1, v druhm bhu zkuste hodnotu 2, ve tetm 10 a v poslednm experimentu hodnotu 50. Jak moc se zmnilo en HIV v jednotlivch ppadech? Odpovdaj tyto vsledky vaim oekvnm? Jsou inky nkterch posuvnk ovlivnny ostatnmi? Napklad, pokud ni hodnota PRUMERNA-DELKA-VZTAHU vede ke zvenmu en viru, pokud jsou ostatn posuvnky na hodnot 0, bude tomu tak i v ppad, e budou vechny ostatn posuvnky na hodnot 10? Mete spustit celou adu experiment k otestovn hypotz o dopadu tchto faktor na zdrav populace.

ROZEN MODELU
-------------------
Stejn jako vechny potaov simulace lidskho chovn, je i tento model vrazn zjednoduen. Z tohoto dvodu je zde mnoho pleitost pro jeho rozen.

Model zobrazuje sexuln aktivitu jako dv postaviky stojc vedle sebe. Pedpokld se tak, e vechny pry jsou sexuln aktivn a e sexuln abstinence je vhradn vlastnost nesprovanch (pohybujcch se) jedinc. Model me bt v tto oblasti zmnn tak, aby odpovdal realistitjmu chovn populace. Dv osoby mohou bt v partnerskm vztahu a zrove spolu nemt sex. K zobrazen sexuln aktivity by tud byla poteba nov grafick reprezentace. Sex me bt napklad symbolizovn tak, e polko pod danm prem zane blikat njakou odlinou barvou.

Tento model tak nezohleduje rozdly mezi pohlavmi. To je zejmm zjednoduenm, nebo vytvoen ist heterosexulnho modelu bylo nevhodn vzhledem k clm zkoumn, kter se maj sousteovat pedevm na celkov zdravotn dopady na populaci bez ohledu na druh sexulnch preferenc. Pesto rozen modelu odlienm pohlav me vst k vce realistickmu modelu.

Model pedpokld, e nakaen jedinci, kte o sv nkaze vd, provozuj pouze a vhradn bezpen sex. Takto popsan lidsk chovn zjevn nen pli realistick, avak dochz dky nmu k emergenci zajmavho chovn modelu, kter je smyslupln z hlediska diskuse o zdrav populace. Pesto by bylo zajmavm rozenm, pokud bychom zmnili reakce jednotlivc na znalost o jejich HIV stavu.
V modelu dle existuje pedpoklad, e pouit kondomu bude vdy na 100 % inn. Ve skutenosti ovem kondom nelze povaovat za zcela dokonalou ochranu proti penosu HIV. Pidejte dku kdu do procedury INFECT k oven nhodn mal ance, e pouit kondomu se v danm kroku mine inkem. Jinou monost pslun procedury je zmnit rozhodovn pru o pouit ochrany. Pokud se ve stvajc verzi modelu partnei neshodnou, zda pout ochranu, vol se ve prospch toho, kdo pouit kondomu odmtne. Je zde mon tuto volbu obrtit.

V neposledn ad lze nkterch vznamnch zmn v modelu doshnout jednoduchou zmnou hodnoty nkter z globlnch promnnch v procedue SETUP-GLOBALS. Dv z tchto promnnch jsou obzvlt hodn pozornosti  jedn se o promnn INFECTION-CHANCE a SYMPTOM-SHOW. Prvn z nich ovlivuje pravdpodobnost, se kterou dojde k penosu nkazy z nemocn osoby na zdravou v ppad, e nen pouita ochrana. Hodnota tto promnn je nastavena na 50, co znamen, e bhem tdennho sexulnho vztahu je 50% ance penosu HIV. Zatm nen jasn, nakolik je tento odhad realistick. SYMPTOM-SHOW je promnn, kter uruje, jak dlouho (v prmru) trv nkaza virem do vskytu prvnch symptom, kter jedince upozorn na ptomnost zdravotnho problmu. V modelu je toto obdob dlouh 200 tdn.

PROGRAMOVAC ZAJMAVOSTI NETLOGA
---------------------
Vimnte si, e tyi procedury, piazujc jednotlivcm v modelu hodnoty jejich sklon, vytv mnoho nhodnch malch sel, ze kterch nsledn model jako celek vychz. Je zde pouito normln rozdlen pro distribuci hodnot tchto sklon. Nhodn slo mezi 0 a 100 me bt 1 stejn jako me nabt hodnoty 99. Ovem pi soutu dvaceti sel mezi 0 a 5 bude vsledek spe 50 ne 99.

V kdu jsou pouity globln promnn SLIDER-CHECK-1 a SLIDER-CHECK-2 a dal, kter odpovdaj aktulnm hodnotm posuvnk tak, aby bylo mon zajistit zmny hodnot posuvnk pi bhu modelu. V kadm asovm kroku je zkontrolovna hodnota pslun promnn posuvnku, zda se nezmnila oproti kroku pedchzejcmu. Pokud se hodnota od minule zmnila, NetLogo spust procedury, kter pizpsob chovn modelu aktulnjm parametrm.

PODKOVN A ODKAZY
----------------------
Zvltn podkovn pat Steve Logeneckerovi za vvoj modelu.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz: Wilensky, U. (1997). NetLogo AIDS model. http://ccl.northwestern.edu/netlogo/models/AIDS. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace: Copyright 1997 Uri Wilensky. All rights reserved. Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/AIDS.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person lefty
false
0
Circle -7500403 true true 170 5 80
Polygon -7500403 true true 165 90 180 195 150 285 165 300 195 300 210 225 225 300 255 300 270 285 240 195 255 90
Rectangle -7500403 true true 187 79 232 94
Polygon -7500403 true true 255 90 300 150 285 180 225 105
Polygon -7500403 true true 165 90 120 150 135 180 195 105

person righty
false
0
Circle -7500403 true true 50 5 80
Polygon -7500403 true true 45 90 60 195 30 285 45 300 75 300 90 225 105 300 135 300 150 285 120 195 135 90
Rectangle -7500403 true true 67 79 112 94
Polygon -7500403 true true 135 90 180 150 165 180 105 105
Polygon -7500403 true true 45 90 0 150 15 180 75 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
