patches-own [
  chemical             ;; mnostv feromon na tomto polku
  food                 ;; mnostv jdla na tomto polku  (0, 1, nebo 2)
  nest?                ;; true na polkch s mravenitm, false vude jinde
  nest-scent           ;; slo, kter je vy, m ble je polko mraveniti
  food-source-number   ;; slo (1, 2, nebo 3), slouc k identifikaci zdroje potravy
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury tlatka Pprav ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape turtles "bug"
  crt populace
  [ set size 2         ;; pro sna viditelnost
    set color red  ]   ;; erven mravenec = nese potravu
  setup-patches
  do-plotting
end

to setup-patches
  ask patches
  [ setup-nest
    setup-food
    recolor-patch ]
end

to setup-nest  ;; procedura polek
  ;; nastav promnnou nest? na hodnotu true uvnit mravenit a na hodnotu false vude jinde
  set nest? (distancexy 0 0) < 5
  ;; rozproste hodnoty promnn nest-scent po cel ploe -- vy hodnoty ble k mraveniti
  set nest-scent 200 - distancexy 0 0
end

to setup-food  ;; procedura polek
  ;; nastav zdroj potravy slo jedna vpravo 
  if (distancexy (0.6 * max-pxcor) 0) < 5
  [ set food-source-number 1 ]
  ;; nastav zdroj potravy slo dva vlevo dole
  if (distancexy (-0.6 * max-pxcor) (-0.6 * max-pycor)) < 5
  [ set food-source-number 2 ]
  ;; nastav zdroj potravy slo ti vlevo nahoe
  if (distancexy (-0.8 * max-pxcor) (0.8 * max-pycor)) < 5
  [ set food-source-number 3 ]
  ;; nastav samotnou "potravu" na polkch se zdroji na hodnotu 1 nebo 2 (nhodn)
  if food-source-number > 0
  [ set food one-of [1 2] ]
end

to recolor-patch  ;; procedura polek
  ;; vybarv polka s mravenitm a se zdroji potravy
  ifelse nest?
  [ set pcolor violet ]
  [ ifelse food > 0
    [ if food-source-number = 1 [ set pcolor cyan ]
      if food-source-number = 2 [ set pcolor sky  ]
      if food-source-number = 3 [ set pcolor blue ] ]
    ;; barevn pechod pro vyjden koncentrace feromonu
    [ set pcolor scale-color green chemical 0.1 5 ] ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury tlatka Start ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go  ;; trval tlatko
  ask turtles
  [ if who >= ticks [ stop ] ;; umouje poten zpodn pro postupn vypoutn mravenc z mravenit
    ifelse color = red
    [ look-for-food  ]       ;; pokud nenese potravu, zani ji hledat
    [ return-to-nest ]       ;; pokud nese potravu, jdi s n zpt do mravenit
    wiggle
    fd 1 ]
  diffuse chemical (mira-rozptylu / 100)
  ask patches
  [ set chemical chemical * (100 - mira-odparovani) / 100  ;; postupn odpauje feromony
    recolor-patch ]
  tick
  do-plotting
end

to return-to-nest  ;; procedura elv
  ifelse nest?
  [ ;; polo potravu v mraveniti a znovu vyra
    set color red
    rt 180 ]
  [ set chemical chemical + 60  ;; vypus trochu feromonu
    uphill-nest-scent ]         ;; oto se smrem k mraveniti
end

to look-for-food  ;; procedura elv
  if food > 0
  [ set color orange + 1     ;; seber potravu
    set food food - 1        ;; na pslunm polku sni mnostv potravy o 1
    rt 180                   ;; a oto se
    stop ]
  ;; jdi smrem, kde je nejsilnj feromonov stopa
  if (chemical >= 0.05) and (chemical < 2)
  [ uphill-chemical ]
end

;; "zavti" vlevo a vpravo a jdi tam, kde byl nejsilnj pach feromonu
to uphill-chemical  ;; procedura elv
  let scent-ahead chemical-scent-at-angle   0
  let scent-right chemical-scent-at-angle  45
  let scent-left  chemical-scent-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

;; "zavti" vlevo a vpravo a jdi tam, kde byl nejsilnj pach cesty k mraveniti
to uphill-nest-scent  ;; procedura elv
  let scent-ahead nest-scent-at-angle   0
  let scent-right nest-scent-at-angle  45
  let scent-left  nest-scent-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

to wiggle  ;; procedura elv
  rt random 40
  lt random 40
  if not can-move? 1 [ rt 180 ]
end

to-report nest-scent-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [nest-scent] of p
end

to-report chemical-scent-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [chemical] of p
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury grafu ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to do-plotting
  if not vykreslit? [ stop ]
  set-current-plot "Potrava v jednotlivch hromdkch"
  ;; jeliko pepna vykreslit? me bt v rznch chvlch 
  ;; zapnut nebo vypnut, musme pout PLOTXY, abychom se ujistili, 
  ;; e graf bude vykreslen ve sprvnch souadnicch osy x
  set-current-plot-pen "food-in-pile1"
  plotxy ticks sum [food] of patches with [pcolor = cyan]
  set-current-plot-pen "food-in-pile2"
  plotxy ticks sum [food] of patches with [pcolor = sky]
  set-current-plot-pen "food-in-pile3"
  plotxy ticks sum [food] of patches with [pcolor = blue]
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant numbers REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 1998.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo Ants model.
; http://ccl.northwestern.edu/netlogo/models/Ants.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1997 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Ants
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
257
10
764
538
35
35
7.0
1
10
1
1
1
0
0
0
1
-35
35
-35
35
1
1
1
ticks

CC-WINDOW
5
552
773
647
Command Center
0

BUTTON
30
70
110
103
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
15
105
205
138
mira-rozptylu
mira-rozptylu
0.0
99.0
50
1.0
1
NIL
HORIZONTAL

SLIDER
15
140
205
173
mira-odparovani
mira-odparovani
0.0
99.0
10
1.0
1
NIL
HORIZONTAL

BUTTON
120
70
195
103
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
85
205
193
238
vykreslit?
vykreslit?
0
1
-1000

SLIDER
15
35
205
68
populace
populace
0.0
200.0
125
1.0
1
NIL
HORIZONTAL

PLOT
5
240
248
436
Potrava v jednotlivch hromdkch
as
potrava
0.0
100.0
0.0
120.0
true
false
PENS
"food-in-pile1" 1.0 0 -11221820 true
"food-in-pile2" 1.0 0 -13791810 true
"food-in-pile3" 1.0 0 -13345367 true

@#$#@#$#@
CO JE TO?
-----------
Tento model ukazuje chovn kolonie mravenc obstarvajcch si potravu. Pestoe kad mravenec jedn podle nkolika jednoduchch pravidel, kolonie jako celek vykazuje komplexn chovn (v kontrastu s jednoduchmi pravidly).

JAK TO FUNGUJE?
------------
Pokud mravenec nalezne kus potravy, odn jej zpt do mravenit a cestou zanechv feromonov znaky. Kdy ostatn mravenci "uct" tento feromon, nsleduj jej, dokud nedoraz k potrav. Jak pibv mravenc nesoucch potravu zpt do mravenit, dochz k posilovn feromonov cesty. 

JAK MODEL OVLDAT
-------------
Tlatko PIPRAV vytvo  mravenit (fialov tvar uprosted) a ti hromdky potravy. Tlatko START zahajuje a ukonuje bh modelu. Feromony jsou v modelu zobrazeny zelonoblm barevnm pechodem.

Nastaven MIRA-ODPAROVANI ovld rychlost, s jakou se feromony vypauj. Nastaven MIRA-ROZPTYLU ovlivuje mru rozptylu feromon. Je zde tak umstn vypna VYKRESLIT?, kter umouje vykreslovn mnostv potravy v jednotlivch hromdkch. Vypnutm tto monosti doshnete zrychlen bhu modelu.

Pokud chcete zmnit celkov mnostv mravenc, zmte nastaven POPULACE ped pouitm tlatka PIPRAV. 

VIMNTE SI
----------------
Mraven kolonie vyerpv jednotliv hromdky potravy v jistm poad. Nejdve je vytena hromdka nejble mraveniti a jako posledn dojde k vyerpn hromdky, kter je od mravenit nejvzdlenj. Pro mravence je nronj vytvoit stabiln feromonovou cestu ke vzdlenj potrav, jeliko feromonov stopa se v prbhu asu rozptyluje a miz asto dve, ne je obnovena.

Ve chvli, kdy kolonie vyerp nejbli zdroj potravy, feromonov stopa pirozenm zpsobem zmiz. Mravenci tak maj monost pomoci ostatnm lenm kolonie pi sbru potravy u jinch zdroj. m je zdroj potravy vzdlenj, tm je zapoteb vy "kritick mnostv" mravenc k vytvoen stabiln feromonov cesty. 

Prbh spoteby potravy je zobrazen v grafu. Rzn barvy kivek v grafu odpovdaj pslunm hromdkm s potravou. 

ROZEN MODELU
-------------------
Zkuste rozmstit zdroje potravy odlinm zpsobem. Co se stane, pokud jsou dv hromdky potravy stejn vzdleny od mravenit? Pokud nastane stejn situace v relnm svt, kolonie mravenc typicky vyt nejdve jeden zdroj, a pak se teprve vrhne na dal (zdroje nejsou vyuvny souasn).

V tomto modelu mravenci vyuvaj jistho triku k tomu, aby nalezli cestu zpt do mravenit: nsleduj smr "stopy k mraveniti (nest scent)". Skuten mravenci vyuvaj mnoha rznch zpsob jak najt cestu zpt do mravenit. Pokuste se implementovat nkter alternativn strategie.

Mravenci reaguj na rove feromonu v rozmez 0.05 a 2. Spodn limit je vyuit k omezen rozpoznvac schopnosti (citlivosti) mravenc. Zkuste odstranit horn limit tohoto omezen. Co se stane? Pro?

V procedue UPHILL-CHEMICAL mravenec "nsleduje gradient" feromonu. To znamen, e "zavt" temi smry a pot se oto ve smru, kde byl pach feromonu nejsilnj. Mete se pokusit vytvoit odlinou proceduru UPHILL-CHEMICAL, ve kter zmnte poet a msta mravenho "zavten".

PROGRAMOVAC ZAJMAVOSTI NETLOGA
----------------
Vyuit primitivum DIFFUSE umouje rozptyl feromon bez sloitch zsah do kdu programu. 

Primitivum PATCH-RIGHT-AND-AHEAD je zde vyuito tak, e mravenec me vyctit feromon v rznch smrech bez nutnosti toho, aby se sm do tchto smr otel.

PODKOVN A ODKAZY
-----------------------
Tento model byl vyvinut v MIT Media Lab s vyuitm CM StarLogo. Pro vce informac viz Resnick, M. (1994) "Turtles, Termites and Traffic Jams: Explorations in Massively Parallel Microworlds."  Cambridge, MA: MIT Press. Pevedeno do jazyka StarLogoT v roce 1997 jako soust projektu Connected Mathematics Project. Adaptace do jazyka NetLogo probhlo v rce 1998 v rmci projektu Participatory Simulations Project.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (1997). NetLogo Ants model.  http://ccl.northwestern.edu/netlogo/models/Ants.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch, uvete prosm tyto informace:  Copyright 1997 Uri Wilensky.  All rights reserved.  
Pro dal informace viz http://ccl.northwestern.edu/netlogo/models/Ants.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
