breed [leaves leaf]
breed [dead-leaves dead-leaf]
breed [raindrops raindrop]
breed [suns sun]

leaves-own [
  water-level       ;; mnostv vody v listu
  sugar-level       ;; mnostv cukru v listu
  attachedness      ;; jak pevn je list pichycen ke stromu
  chlorophyll       ;; rove chemickch ltek zpsobujcch zelen zbarven listu
  carotene          ;; rove chemickch ltek zpsobujcch lut zbarven listu
  anthocyanin       ;; rove chemickch ltek zpsobujcch erven zbarven listu
]

raindrops-own [
  location          ;; oblasti s vodou, mohou nabvat hodnoty "falling" (padajc), "in root" (v koenech), "in trunk" (v kmeni), or "in leaves (v listech)"
  amount-of-water
]

globals [
  bottom-line        ;; ovld vku zem
  evaporation-temp   ;; teplota pi kter se vypauje voda
]

;; ---------------------------------------
;; PROCEDURY TLATKA PIPRAV
;; ---------------------------------------

to setup
  clear-all
  set bottom-line min-pycor + 1
  set evaporation-temp 30
  set-default-shape raindrops "circle"
  set-default-shape suns "circle"

  ;; Vytvo nebe a trvu
  ask patches
    [ set pcolor blue - 2 ]
  ask patches with [pycor < min-pycor + 2]
    [ set pcolor green ]

  ;; Vytvo listy
  create-leaves pocet-listu [
    set chlorophyll 50 + random 50
    set water-level 75 + random 25
    ;; hladina cukru odpovd normlnmu rozdlen, urenmu nsledujcmi (uivatelem) definovanmi vstupy
    set sugar-level random-normal pocatecni-cukr-str-hodnota pocatecni-cukr-smer-odchylka
    set carotene random 100
    change-color
    set attachedness 100 + random 50
    ;; Pouit "sqrt" (odmocnina) v nsedujcm pkazu zpsob
    ;; rovnomrn rozloen elv; pokud bychom zadali pouze "fd random-float 10",
    ;; bylo by vce elv bl u stedu stromu, co by vypadalo smn.
    
    fd sqrt random-float 100
  ]

  ;; Vytvo kmen a vtve
  ask patches with [pxcor = 0 and pycor <= 5 or
                    abs pxcor = (pycor + 2) and pycor < 4 or
                    abs pxcor = (pycor + 8) and pycor < 3]
    [ set pcolor brown ]

  ;; Vytvo slunce
  create-suns 1 [
    setxy max-pxcor - 2
          max-pycor - 3
    ;; uprav vzhled slunce podle jeho intenzity
    show-intensity
  ]

  ;; zanese do grafu poten stav
  do-plot
end


;; ---------------------------------------
;; PROCEDURY TLATKA START
;; ---------------------------------------

to go
  ;; Zastav model, pokud jsou vechny listy mrtv
  if not any? leaves [ stop ]

  ;; Nsledujc procedury zajist foukn vtru a padn kapek det;
  ;; dle pohyb vody na nebi, v zemi i ve strom;
  ;; nastav vzhled slunce podle jeho intenzity
  make-wind-blow
  make-rain-fall
  move-water
  ask suns [ show-intensity ]

  ;; Nastav listm hodnoty dle pslunch parametr
  ask attached-leaves
  [
    adjust-water
    adjust-chlorophyll
    adjust-sugar
    change-color
    change-shape
  ]

  ;; Pokud listy opadaj, budou pokraovat v padn
  ask leaves [ fall-if-necessary ]

  ;; Pokud se opadajc listy dotkou zem, zemou
  ask leaves with [ycor <= bottom-line]
    [ set breed dead-leaves ]

  ;; Listy bez vody tak zemou
  ask leaves with [water-level < 1]
    [ set attachedness 0 ]

  ;; Kontroluje, zda jsou pslun hodnoty v intervalu 0 - 100
  ask leaves [
    if chlorophyll < 0 [ set chlorophyll 0 ]
    if chlorophyll > 100 [ set chlorophyll 100 ]
    if water-level < 0 [ set water-level 0 ]
    if water-level > 100 [ set water-level 100 ]
    if sugar-level < 0 [ set sugar-level 0 ]
    if sugar-level > 100 [ set sugar-level 100 ]
    if carotene < 0 [ set carotene 0 ]
    if carotene > 100 [ set carotene 100 ]
    if anthocyanin < 0 [ set anthocyanin 0 ]
    if anthocyanin > 100 [ set anthocyanin 100 ]
    if attachedness < 0 [ set attachedness 0 ]
    if attachedness > 100 [ set attachedness 100 ]
  ]

  ;; Zv as o jeden krok
  tick

  ;; Vykresl aktuln dn v modelu do graf
  do-plot
end


;; ---------------------------------------
;; Procedura foukn vtru. Kdy vtr fouk,
;; listy se lehce pohybuj (co m pkn 
;; vizuln efekt) a redukuje se jejich faktor 
;; pilnavosti podle sly vtru. To
;; znamen, e listy budou padat rychleji,
;; pokud bude vtr silnj.
;; ---------------------------------------

to make-wind-blow
  ask leaves [ ifelse random 2 = 1
                 [ rt 10 * sila-vetru ]
                 [ lt 10 * sila-vetru ]
               set attachedness attachedness - sila-vetru
             ]
end


;; ---------------------------------------
;; Procedura padn det. D隝 m svj vlast rod (breed)
;; malch elv, kter se pohybuj od hornho okraje okna modelu. 
;; ---------------------------------------

to make-rain-fall
  ;; Vytvo nov deov kapky na horn hranici okna
  create-raindrops intenzita-deste [
    setxy random-xcor max-pycor
    set heading 180
    fd 0.5 - random-float 1.0
    set size .3
    set color gray
    set location "falling"
    set amount-of-water 10
  ]
  ;; Rozpohybuje vechny kapky, vetn tch,
  ;; kter byly prv vytvoeny
  ask raindrops [ fd random-float 2 ]
end


;; --------------------------------------------------------
;; Procedura pohybu vody: Voda se pohybuje kapky -> zem,
;; zem -> kmen/vtve a z kmene/vtv do list.
;; --------------------------------------------------------

to move-water

  ;; Pedpokldme, e koeny zabraj celou plochu zobrazen travnat zem.
  ;; Deov voda se pesunuje ze zem do kmene stromu.
  ask raindrops with [location = "falling" and pcolor = green] [
    set location "in roots"
    face patch 0 ycor
  ]

  ;; Voda je vedena z kmene do stedn sti stromu.
  ask raindrops with [location = "in roots" and pcolor = brown] [
    face patch 0 0
    set location "in trunk"
  ]

  ;; Voda se pohybuje z kmene do list. Nen zde 
  ;; simulovn reln pohyb skrze vtve stromu.
  ask raindrops with [location = "in trunk" and patch-here = patch 0 0] [
    set location "in leaves"
    set heading random 360
  ]

  ;; Pokud se deov kapka dostane do listu a dn pebyten voda nezbyde, pak kapka zmiz.
  ask raindrops with [location = "in leaves" and amount-of-water <= 0.5] [
    die
  ]

  ;; Pokud je kapka v kmeni a u nejsou voln listy,
  ;; kam by mohla tci, pak kapka tak zmiz.
  ask raindrops with [
    (location = "in trunk" or location = "in leaves")
     and (ycor > max [ycor] of leaves or
          xcor > max [xcor] of leaves or
          xcor < min [xcor] of leaves) ] [
    die
  ]

end

;;---------------------------------------------------------
;; PROCEDURY ELV
;; --------------------------------------------------------

;; --------------------------------------------------------
;; Procedura zobrazen intenzity. Mn zobrazen slunce 
;; podle intenzity jeho svitu.
;; --------------------------------------------------------

to show-intensity  ;; procedura slunce
  set color scale-color yellow intenzita-slunce 0 150
  set size intenzita-slunce / 10
  set label word intenzita-slunce "%"
  ifelse intenzita-slunce < 50
    [ set label-color yellow ]
    [ set label-color black  ]
end

;; --------------------------------------------------------
;; Procedura nastaven vody. 
;; Zvyuje a sniuje hladinu vody v listech.
;; --------------------------------------------------------

to adjust-water
  ;; Pod jistou hranic teploty pestanou listy absorbovat vodu.
  ;; Msto n pemuj cukr a vodu na anthokyanin.
  if teplota < 10 [ stop  ]

  ;; Pokud je v blzkosti listu kapka s aplespo trochou vody,
  ;; vsteb list st tto vody.
  let nearby-raindrops raindrops in-radius 2 with [location = "in leaves" and amount-of-water >= 0]

  if any? nearby-raindrops [
    let my-raindrop min-one-of nearby-raindrops [distance myself]
    set water-level water-level + ([amount-of-water] of my-raindrop * 0.20)
    ask my-raindrop [
      set amount-of-water (amount-of-water * 0.80)
    ]
  ]

  ;; Sn mnostv vody v zvislosti na teplot
  if teplota > evaporation-temp
    [ set water-level water-level - (0.5 * (teplota - evaporation-temp)) ]

  ;; Pokud je hladina vody v listu pli nzk, sniuje se jeho pilnavost
  if water-level < 25
    [ set attachedness attachedness - 1 ]

end


;; ---------------------------------------
;; Procedura nastaven chlorofylu. Mnostv chlorofylu se
;; sniuje, pokud je teplota pli nzk nebo kdy je slunce pli siln.
;; Mnostv chlorofylu se naopak zvyuje za normln teploty a pimnho  
;; dostatku slunenho svtla.
;; ---------------------------------------

to adjust-chlorophyll

  ;; Pokud je teplota pli nzk, sn mnostv chlorofylu
  if teplota < 15
    [ set chlorophyll chlorophyll - (.5 * (15 - teplota)) ]

  ;; Pokud slunce pli siln, sn mnostv chlorofylu
  if intenzita-slunce > 75
    [ set chlorophyll chlorophyll - (.5 * (intenzita-slunce - 75)) ]

  ;; Nov chlorofyl zpsoben pimenm teplem a svtlem.
  if teplota > 15 and intenzita-slunce > 20
    [ set chlorophyll chlorophyll + 1 ]

end


;; ---------------------------------------
;; Procedura nastaven cukru. Voda + slunen svtlo + chlorofyl = cukr.
;; ---------------------------------------

to adjust-sugar
  ;; Pokud je k dispozici dostatek vody a slunenho svtla, sn mnostv
  ;; chlorfylu a vody a zv hladinu cukru.
  if water-level > 1 and intenzita-slunce > 20 and chlorophyll > 1
    [ set water-level water-level - 0.5
      set chlorophyll chlorophyll - 0.5
      set sugar-level sugar-level + 1
      set attachedness attachedness + 5
    ]

  ;; S kadm asovm krokem se sn hladina cukru o 1.
  set sugar-level sugar-level - 0.5
end

;; ---------------------------------------
;; Procedura padn list. Pokud je list v prostoru mezi 
;; korunou stromu a hranic zem, pak pad.
;; Ve chvli dopadu na zem umr.
;; ---------------------------------------

to fall-if-necessary
  if attachedness > 0 [ stop ]
  if ycor > bottom-line
    [
      let target-xcor (xcor + random-float sila-vetru
                            - random-float sila-vetru)
      facexy target-xcor bottom-line
      fd random-float (.7 * max (list sila-vetru .5))
     ]
end


;; ---------------------------------------
;; Procedura zmny barev. Jeliko m NetLogo omezenou paletu barev,
;; potebujeme velmi jednoduch pravidla. 
;; ---------------------------------------

to change-color
  ;; Pokud je teplota nzk, promn 
  ;; cukr na anthokyanin.
  if teplota < 20 and sugar-level > 0 and water-level > 0
    [ set sugar-level sugar-level - 1
      set water-level water-level - 1
      set anthocyanin anthocyanin + 1 ]

  ;; Pokud je chlorofylu vce ne 50 procent, pak se list zbarv 
  ;; zelen a to v takovm odstnu, kter odpovd koncentraci chlorofylu.
  ifelse chlorophyll > 50
       [ set color scale-color green chlorophyll 150 -50 ]

  ;; Pokud je v listu mn ne 50 procent chlorofylu, pak se
  ;; zbarv lut (podle koncentrace karotenu), erven (podle koncentrace anthokyaninu) 
  ;; nebo oranov (pokud jsou ob zmnn koncentrace stejn vysok).

       ;; Pokud je zhruba stejn mnostv karotenu a anthokyaninu
       ;; pak m mt list oranov odstny.
       [ if abs (anthocyanin - carotene ) < 10
           [ set color scale-color orange carotene 150 -50 ]

         if anthocyanin > carotene + 10
           [ set color scale-color red anthocyanin 170 -50 ]

         if carotene > anthocyanin + 10
           [ set color scale-color yellow carotene 150 -50 ]
       ]
end

to change-shape
  ifelse zobrazeni-listu = "pevn"
    [ set shape "default" ]
  [ if zobrazeni-listu = "chlorofyl"
      [ set-shape-for-value chlorophyll ]
    if zobrazeni-listu = "voda"
      [ set-shape-for-value water-level ]
    if zobrazeni-listu = "cukr"
      [ set-shape-for-value sugar-level ]
    if zobrazeni-listu = "karoten"
      [ set-shape-for-value carotene ]
    if zobrazeni-listu = "anthokyaniny"
      [ set-shape-for-value anthocyanin ]
    if zobrazeni-listu = "pilnavost"
      [ set-shape-for-value attachedness ]
  ]
end


;; ---------------------------------------
;; PROCEDURY GRAF
;; ---------------------------------------

;; ---------------------------------------
;; Procedury graf. Vykresluj do graf 
;; aktuln hodnoty promnnch.
;; ---------------------------------------

to do-plot
    ;; Vykresluje informaci o potu list
    set-current-plot "Listy"

    set-current-plot-pen "listy"
    plot count leaves

    set-current-plot-pen "mrtv listy"
    plot count dead-leaves

    ;; Vykresluje informace o podnebnch podmnkch
    set-current-plot "Poas"

    set-current-plot-pen "teplota"
    plot teplota

    set-current-plot-pen "slunen svit"
    plot intenzita-slunce

    set-current-plot-pen "d隝"
    plot intenzita-deste

    set-current-plot-pen "vtr"
    plot sila-vetru

    ;; Vykresluje informace o listech
    if any? leaves [

      set-current-plot "Charakteristiky list (prmry)"

      set-current-plot-pen "voda"
      plot mean [water-level] of leaves

      set-current-plot-pen "chlorofyl"
      plot mean [chlorophyll] of leaves

      set-current-plot-pen "cukr"
      plot mean [sugar-level] of leaves

      set-current-plot-pen "karoten"
      plot mean [carotene] of leaves

      set-current-plot-pen "anthokyaniny"
      plot mean [anthocyanin] of leaves

      set-current-plot-pen "pilnavost"
      plot mean [attachedness] of leaves
   ]
end

;; Vrac vechny listy, kter jet neopadly
to-report attached-leaves
  report leaves with [attachedness > 0]
end

;; Mn zobrazen listu podle toho, zda jsou vce i mn pln zvolench chemickch ltek. 
to set-shape-for-value [value]
  ifelse value > 75 [ set shape "default" ]
  [ ifelse value <= 25 [ set shape "default one-quarter" ]
    [ ifelse value <= 50 [ set shape "default half" ]
                         [ set shape "default three-quarter" ]]]
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; Copyright 2005 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2005).  NetLogo Autumn model.
; http://ccl.northwestern.edu/netlogo/models/Autumn.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2005 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Autumn
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
350
154
710
535
17
17
10.0
1
12
1
1
1
0
0
0
1
-17
17
-17
17
1
1
1
ticks

SLIDER
12
15
343
48
pocet-listu
pocet-listu
1
2500
278
1
1
NIL
HORIZONTAL

BUTTON
385
16
456
49
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
500
79
705
112
sila-vetru
sila-vetru
0
10
3
1
1
NIL
HORIZONTAL

BUTTON
386
54
456
87
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
500
10
707
43
teplota
teplota
0
40
10
1
1
stup Celsia
HORIZONTAL

SLIDER
500
44
706
77
intenzita-deste
intenzita-deste
0
30
19
1
1
NIL
HORIZONTAL

SLIDER
500
115
706
148
intenzita-slunce
intenzita-slunce
0
100
97
1
1
%
HORIZONTAL

PLOT
11
151
342
281
Listy
as
NIL
0.0
10.0
0.0
100.0
true
true
PENS
"listy" 1.0 0 -10899396 true
"mrtv listy" 1.0 0 -6459832 true

PLOT
11
282
343
402
Poas
as
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"teplota" 1.0 0 -2674135 true
"d隝" 1.0 0 -13345367 true
"vtr" 1.0 0 -16777216 true
"slunen svit" 1.0 0 -1184463 true

PLOT
11
401
342
532
Charakteristiky list (prmry)
as
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"chlorofyl" 1.0 0 -10899396 true
"voda" 1.0 0 -13345367 true
"cukr" 1.0 0 -7500403 true
"karoten" 1.0 0 -1184463 true
"anthokyaniny" 1.0 0 -2674135 true
"pilnavost" 1.0 0 -16777216 true

SLIDER
68
60
276
93
pocatecni-cukr-str-hodnota
pocatecni-cukr-str-hodnota
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
68
101
276
134
pocatecni-cukr-smer-odchylka
pocatecni-cukr-smer-odchylka
0
50
25
1
1
NIL
HORIZONTAL

CHOOSER
351
102
495
147
zobrazeni-listu
zobrazeni-listu
"pevn" "chlorofyl" "voda" "cukr" "karoten" "anthokyaniny" "pilnavost"
0

@#$#@#$#@
CO TO JE?
---------

Pokud ijete v podneb, kde se stdaj hork lta s chladnmi zimnmi obdobmi, pak zejm znte pekrsn podzimn jev, pi kterm listy mn barvy pedtm, ne uhynou a opadnou ze strom. Tento model simuluje proces, ve kterm dochz ke zmnm barvy a opadvn, m umouje prozkoumat a pochopit tuto ndhernou kadoron podvanou. 

JAK TO FUNGUJE?
---------------

Dvody, pro a jak listy mn svou barvu a opadaj, jsou pekvapiv sloit a souvis s kombinac slunenho svitu, tepla a det. (Listy mohou bt tak odfouknuty silnm vtrem, dokonce, i kdy jet nezaaly mnit barvu, tud vtr tak hraje svoji roli.)

Barvy, kter lze pozorovat na stonku kadho listu, jsou zpsobeny ptomnost ltek, kter jsou tvoeny a uloeny v kadm listu. Celkem ti ltky ovlivuj barvu list.

Zelenou barvu zpsobuje chlorofyl (nebo mnoina pbuznch ltek, znm jako chlorofyly), kter pemuje slunen svtlo a vodu na cukr. Molekuly chlorofylu jsou nieny a nejsou obnovovny, pokud jsou vystaveny nadmrnmu slunenmu svitu a nzkm teplotm. Proto studen a slunen podzimn dny zpsobuj pokles koncentrace chlorofylu. Celkov koncentrace chlorofylu roste s mnostvm slunenho svtla (dokud ho nen pli mnoho) za ptomnosti dostatku vody.

lut barva je zpsobena ltkou s nzvem karoten. Molekuly karotenu mimo jin zapiuj tak typick zbarven mrkve. Koncentrace karotenu zstv v prbhu ivota kadho listu konstantn. Pesto je lut barva asto pekryta zelenou barvou chlorofylu. List s vysokou hladinou chlorofylu (typicky v lt) bude zcela zelen, akoliv bude obsahovat odstny lut, maskovan zelenou barvou. Jak postupn chlorofylu ubv, stv se ptomnost karotenu stle vce npadn, a je nakonec cel list lut.

ervenou barvu zpsobuje ltka nazvan anthokyanin. Molekuly anthokyaninu jsou vytveny za ptomnosti vysok koncentrace cukru a vody v listech. (m vy je koncentrace cukru, tm vce je vytvoeno anthokyaninu.) Koncentrace cukru se zvyuje, kdy studen poas zpsob uzaven obhu vody do zbytku stromu; voda a cukr jsou pak zachyceny v listu a pemnny v anthokyaniny.

V kadm asovm kroku modelu probhaj dva procesy: 1) poas (d隝, vtr, slunce) psob na listy, m pozitivn i negativn ovlivuje hladiny cukru, vody a chlorofylu; 2) listy reaguj na sv vnj prosted, vytvej dle aktuln situace anthokyaniny a mn barvu.

Voda se nedostv do list pmo, ale je absorbovna koeny stromu, ze kterch putuje kmenem do vtv a dle do list. V tomto modelu se pedpokld, e je cel zobrazen zem protkna koeny a veker kapky det jsou vstebny do kmene stromu, jakmile dopadnou na zem. Stejnm zpsobem putuj veker kapky vody kmenem do vtven stromu (kter v modelu nen znzornno) a nsledn do list. Listy v sob zadruj vodu z deovch kapek. Kapky zmiz ve chvli, kdy ji neobsahuj dnou vodu.

Listy v modelu maj vlastnost pilnavost, kter uruje, jak siln je list pichycen ke stromu. Pilnavost se zvyuje s mnostvm vody a je snena bhem det a vtru. (Za velmi vtrnho dne mohou bt listy odfouknuty, i kdy jsou jet pln zelen.)

Protoe paleta barev NetLoga neobsahuje vechny potebn odstny barev, vyuv tento model algoritmus pro vpoet prahovch hodnot, pi kterch dojde ke zmnm barvy (jako odhad namsto skutench barev). Pokud je hladina chlorofylu vce ne 50%, list je zelen. Pod touto hranic zskv list lut, erven a oranov barevn odstny v zvislosti na koncentraci karotenu a anthokyanin.

Vimnte si, e se sytost kad barvy mn podle hladiny chlorofylu, karotenu a/nebo anthokyanin. Proto chlorofylem nasycen stromy maj tmav zelen listy, zatmco ty s ni koncentrac maj listy se svtlmi odstny zelen barvy. 

JAK MODEL OVLDAT
-----------------

Ped sputnm modelu stisknte tlatko PIPRAV. Tm vytvote v modelu kmen s vtvemi a zrove tm dojde k vytvoen list, kter jsou hlavnmi agenty v tomto modelu. Tlatkem START uvedete model do pohybu.

Te pichz ta zajmav st, kterou je nastavovn posuvnk v uivatelskm rozhrann. Tm vytvote potebn podmnky, kter chcete zkoumat. Pokud listy vypadaj, e ztrc chlorofyl v dsledku nedostatku vody (jej rove mete sledovat v grafu Charakteristiky list (prmry), mete ovlivnit jej mnostv pomoc posuvnku INTENZITA-DESTE. Posuvnkem SILA-VETRU zase mete zapojit do modelu vliv vtru.

Slu slunce (ve smyslu intenzity slunenho svtla) lze nastavit pomoc posuvnku INTENZITA-SLUNCE. Jak bylo zmnno ve, listy potebuj slunen svit k vytven chlorofylu a cukru -- avak pli mnoho slunenho svitu me naopak zpsobit znien tchto chemickch ltek.

Nakonec zmte hodnotu posuvnku TEPLOTA. Pokud je teplota pli nzk, dojde k rozpadu molekul chlorofylu na kor tvorby anthokyanin.

Pot, co si osvojte zkladn ovldn modelu, mete se vnovat nastaven dvou posuvnk v levm hornm rohu - POCATECNI-CUKR-STR-HODNOTA a POCATECNI-CUKR-SMER-ODCHYLKA, kter maj vliv na stedn hodnotu a rozptyl poten distribuce cukru mezi jednotliv listy. Kupkladu javorov listy maj sklon zanat s vy koncentrac cukru, kter zpsobuje ervenj zbarven ne u ostatnch list pi jinak stejnch podmnkch.

Pomoc ZOBRAZENI-LISTU lze zmnit zpsoby zobrazen list. Normln m kad list pevnou barvu podle standardnch agent (elv) v NetLogu. V tomto ppad je ZOBRAZENI-LISTU nastaveno na pevn. Ostatn hodnoty tohoto nastaven zobrazuj listy v przdnm, poloprzdnm a plnm tvaru v zvislosti na promnn, kterou maj zobrazovat. Pokud tedy napklad ZOBRAZENI-LISTU nastavte na voda, bude kad z list zobrazen jako przdn (pokud m mlo vody), poloprzdn (pokud m o trochu vce vody), nebo pln (pokud je relativn pln vody). 

VIMNTE SI
-----------

Listy absorbuj vodu, kdy na n dopadaj deov kapky -- to znamen, e mrn d隝 a vysok poet list zpsob, e deov voda nepronikne k vnitnm listm koruny.

m silnj vtr, tm vce se kad list tese (a tm m tak vt anci opadnout).

Mete simulovat dopad menho huriknu pomoc nastaven sly vtru a det na jejich maximln hodnoty. Sledujte, jak vechny listy narz opadnou! 

VYZKOUEJTE SI
--------------

Dokete zadit, aby vechny listy zervenaly pedtm, ne opadnou? Dokete to sam s oranovou barvou? A co se lutou? Nyn zkuste ve zkombinovat tak, aby ten sam strom ml listy vce rznch barev. (Npovda: Budete pravdpodobn muset nkolikrt upravit hodnoty posuvnk urujcch vliv slunce, det a teploty, abyste doshli sprvn kombinace.)

Pokuste se zmnit barvu list na lutou a pot opt na zelenou.

V nkterch podnebnch psech stromy vbec neztrcej sv listy. Dokete pizpsobit poas tak, aby na strom zstaly alespo nkter z jeho list? 

ROZEN MODELU
----------------

Ve skutenm ivot listy vystaven pmmu slunci maj sklon k tomu, aby byly vce lut ne ty, kter pmmu slunci vystaven nejsou. Upravte model tak, aby bylo mon vybrat (a mnit) pozici slunce. Pidejte navc podmnku, urujc, e listy vystaven pmmu slunci jsou vce citliv na jeho svtlo ne ty, kter pmmu svtlu vystaven nejsou.

Model je velmi zjednoduen, co se te pojet vody a cukru - a to konkrtn tak, e veker voda pochz z det, kapky det mohou psobit na vce list a miz po dopadu na zem. Realistitj model by ml umoovat zmizen kapky po jej dopadu na list, ale zrove by ml dovolit vod proudit ze zem skrz kmen a vtve. Vce realistick model by ml tak obsahovat proces penen cukr mezi listy a ukldn pebytenho cukru v koenech stromu.

Pidejte do modelu puen a rst novch list, kter budou nahrazovat mrtv a odpadl listy.

Upravte model zavedenm cyklickho stdn dne a noci, pi kterm vdy na nkolik asovch krok klesne teplota a zapadne slunce. Ve tm by pak strom spotebovval cukry a vytvel vodu pomoc respirace. 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------

Jeliko je paleta barev NetLoga nepln, potebovali jsme mrn zamaskovat zbarven list. Vimnte si, e pouvme k nastaven barev prahov hodnoty. To znamen, e v modelu me dochzet k nhlm a vraznm zmnm barev, pokud je poas tak trochu extrmn.

Vimnte si tak, e paleta barev NetLoga a primitivum SCALE-COLOR vytv barvy v rozsahu od bl do ern. Jeliko v tomto modelu chceme zskat rozdln barevn odstny bez toho, abychom se pli piblili ern nebo bl barv, pouvme primitivum scale-color v intervalu od -50 d 150 namsto bnho rozsahu od 0 do 100.

Pokud list zeme, jeho rod (breed) se zmn na dead leaves (mrtv listy). Proto je sice stle ptomen v modelu, avak veker pkazy u ovlivuj pouze iv listy.

Vimnte si, jak se mn barva slunce pi zmn hodnoty INENZITA-SLUNCE. Co se stane s popiskem slunce (udvajc seln jeho intenzitu), kdy slunce ztmavne a zmen se? 

SOUVISEJC MODELY
------------------

Model Plant Growth (Pstovn rostliny) popisuje v jistch smrech opan proces - konkrtn to, jak listy rostou (namsto toho, jak listy umraj).


PODKOVN A ODKAZY
----------------------
http://scifun.chem.wisc.edu/chemweek/fallcolr/fallcolr.html
http://www.the-scientist.com/article/display/12772/

Podkovn pat Reuvenu Lernerovi za prci na tomto modelu.

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (2005).  NetLogo Autumn model.  http://ccl.northwestern.edu/netlogo/models/Autumn.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:  Copyright 2005 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/Autumn for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

1
true
0
Polygon -7500403 true true 150 7 150 204 203 130
Line -7500403 true 150 7 42 248
Line -7500403 true 41 250 149 204
Line -7500403 true 149 204 259 248
Line -7500403 true 150 8 260 249
Polygon -7500403 true true 150 8 150 205 42 252

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

default empty
true
0
Line -7500403 true 150 7 42 248
Line -7500403 true 41 250 149 204
Line -7500403 true 149 204 259 248
Line -7500403 true 150 8 260 249

default half
true
0
Line -7500403 true 150 7 42 248
Line -7500403 true 41 250 149 204
Line -7500403 true 149 204 259 248
Line -7500403 true 150 8 260 249
Polygon -7500403 true true 150 7 150 204 42 251

default one-quarter
true
0
Line -7500403 true 150 7 42 248
Line -7500403 true 41 250 149 204
Line -7500403 true 149 204 259 248
Line -7500403 true 150 8 260 249
Polygon -7500403 true true 91 133 151 203 42 252

default three-quarter
true
0
Line -7500403 true 150 7 42 248
Line -7500403 true 41 250 149 204
Line -7500403 true 149 204 259 248
Line -7500403 true 150 8 260 249
Polygon -7500403 true true 150 7 150 204 211 140
Polygon -7500403 true true 150 7 150 204 42 251

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
setup
repeat 30 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
